package inventor.viewercomponents.awt.newt.renderareaexaminer;

import java.awt.BorderLayout;

import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.viewercomponents.awt.newt.renderareas.RenderAreaExaminer;

import util.Example;

public class Main extends Example
{

  private static final short HEIGHT = 480;
  private static final short WIDTH = 640;

  private RenderAreaExaminer m_renderArea;

  @Override
  public void start()
  {
    m_renderArea = new RenderAreaExaminer();
    m_renderArea.setSceneGraph(new SoCone());
    m_renderArea.viewAll(new SbViewportRegion(WIDTH, HEIGHT));

    m_renderArea.setPreferredSize(new java.awt.Dimension(WIDTH, HEIGHT));
    setLayout(new BorderLayout());
    add(m_renderArea);
  }

  @Override
  public void stop()
  {
    m_renderArea.dispose();
  }

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain("Open Inventor SoCone, using NEWT RenderAreaExaminer");
  }

}
