package inventor.viewercomponents.swt.glcanvas.renderarea;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.nodes.SoDirectionalLight;
import com.openinventor.inventor.nodes.SoPerspectiveCamera;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.swt.glcanvas.renderareas.RenderArea;

public class Main
{

  private static final short HEIGHT = 480;
  private static final short WIDTH = 640;

  private static SoSeparator buildSceneGraph()
  {
    SoPerspectiveCamera camera = new SoPerspectiveCamera();
    SoSeparator rootSceneGraph = new SoSeparator();
    {
      rootSceneGraph.addChild(camera);
      rootSceneGraph.addChild(new SoDirectionalLight());
      rootSceneGraph.addChild(new SoCone());
    }

    camera.viewAll(rootSceneGraph, new SbViewportRegion(WIDTH, HEIGHT));
    return rootSceneGraph;
  }

  public static void main(String[] args)
  {
    Display display = new Display();
    Shell shell = new Shell(display);
    shell.setSize(WIDTH, HEIGHT);
    shell.setText("Open Inventor SoCone, using RenderArea");
    shell.setLayout(new FillLayout(SWT.HORIZONTAL));

    RenderArea renderArea = new RenderArea(shell, SWT.NONE);
    renderArea.setSceneGraph(buildSceneGraph());

    shell.open();
    while ( !shell.isDisposed() )
    {
      if ( !display.readAndDispatch() )
        display.sleep();
    }
    display.dispose();
  }
}
