package inventor.viewercomponents.swt.glcanvas.renderareaexaminer;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.viewercomponents.swt.glcanvas.renderareas.RenderAreaExaminer;

public class Main
{

  private static final short HEIGHT = 480;
  private static final short WIDTH = 640;

  public static void main(String[] args)
  {
    Display display = new Display();
    Shell shell = new Shell(display);
    shell.setSize(WIDTH, HEIGHT);
    shell.setText("Open Inventor SoCone, using RenderAreaExaminer");
    shell.setLayout(new FillLayout(SWT.HORIZONTAL));

    RenderAreaExaminer renderArea = new RenderAreaExaminer(shell, SWT.NONE);
    renderArea.setSceneGraph(new SoCone());
    renderArea.viewAll(new SbViewportRegion(WIDTH, HEIGHT));

    shell.open();
    while ( !shell.isDisposed() )
    {
      if ( !display.readAndDispatch() )
        display.sleep();
    }
    display.dispose();
  }
}
