package inventor.viewercomponents.swt.glcanvas.renderareaguiintegration;

import java.io.File;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.viewercomponents.swt.glcanvas.viewers.ViewerExaminer;
import com.openinventor.inventor.viewercomponents.swt.tools.SWTResourceManager;
import com.openinventor.ivtune.SoIvTune;

public class Main
{
  private static ViewerExaminer viewer;

  public static void main(String[] args)
  {
    final Display display = new Display();
    final Shell shell = new Shell(display);
    shell.setSize(700, 600);
    shell.setText("Simple SWT viewer");
    shell.setLayout(new GridLayout(2, false));

    viewer = new ViewerExaminer(shell);

    buildMenu(shell);
    shell.open();
    while ( !shell.isDisposed() )
    {
      if ( !display.readAndDispatch() )
        display.sleep();
    }
    SWTResourceManager.dispose();
    display.dispose();
  }

  private static void buildMenu(final Shell shell)
  {
    Menu menu = new Menu(shell, SWT.BAR);
    shell.setMenuBar(menu);

    MenuItem cascadeMenuFile = new MenuItem(menu, SWT.CASCADE);
    cascadeMenuFile.setText("File");

    Menu menuFile = new Menu(cascadeMenuFile);
    cascadeMenuFile.setMenu(menuFile);

    MenuItem loadFileMenuItem = new MenuItem(menuFile, SWT.NONE);
    loadFileMenuItem.addSelectionListener(new SelectionAdapter()
    {
      @Override
      public void widgetSelected(SelectionEvent e)
      {
        String[] filterNames = new String[] { "Iv Files" };
        String[] filterExtensions = new String[] { "*.iv" };

        FileDialog dialog = new FileDialog(shell, SWT.OPEN);
        dialog.setFilterNames(filterNames);
        dialog.setFilterExtensions(filterExtensions);
        dialog.setFilterPath(SoPreferences.getValue("OIVJHOME") + File.separator + "data" + File.separator + "models");

        String ivFile = dialog.open();
        if ( ivFile != null )
          viewer.loadSceneGraph(ivFile);
      }
    });
    loadFileMenuItem.setImage(null);
    loadFileMenuItem.setText("Open");

    MenuItem IvTuneMenuItem = new MenuItem(menuFile, SWT.NONE);
    IvTuneMenuItem.addSelectionListener(new SelectionAdapter()
    {
      @Override
      public void widgetSelected(SelectionEvent e)
      {
        SoIvTune.start(viewer.getRenderArea().getSceneInteractor());
      }
    });
    IvTuneMenuItem.setImage(null);
    IvTuneMenuItem.setText("Run IvTuneViewer");

    @SuppressWarnings("unused")
    MenuItem separator = new MenuItem(menuFile, SWT.SEPARATOR);

    MenuItem exitMenuItem = new MenuItem(menuFile, SWT.NONE);
    exitMenuItem.addSelectionListener(new SelectionAdapter()
    {
      @Override
      public void widgetSelected(SelectionEvent e)
      {
        System.exit(0);
      }
    });
    exitMenuItem.setImage(null);
    exitMenuItem.setText("Exit");
  }
}
