package launcher;

import java.io.File;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Vector;

import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

import util.Example;

public class DirTreeNode
{

  protected File m_file;
  protected Vector<String> m_examplesClassList;
  protected Vector<String> m_examplesNameList;
  protected int m_currentExampleIndex;

  public DirTreeNode(File f)
  {
    m_file = f;
    m_examplesClassList = new Vector<String>();
    m_examplesNameList = new Vector<String>();
    makeExamplesList();
    m_currentExampleIndex = -1;
  }

  public File getFile()
  {
    return m_file;
  }

  public Vector<String> getExamplesClassList()
  {
    return m_examplesClassList;
  }

  public Vector<String> getExamplesNameList()
  {
    return m_examplesNameList;
  }

  public int getExamplesCount()
  {
    return m_examplesClassList.size();
  }

  public int getCurrentExampleIndex()
  {
    return m_currentExampleIndex;
  }

  public void setCurrentExampleIndex(int index)
  {
    m_currentExampleIndex = index;
  }

  public String getCurrentExampleClass()
  {
    return m_examplesClassList.get(m_currentExampleIndex);
  }

  public String getCurrentExampleName()
  {
    return m_examplesNameList.get(m_currentExampleIndex);
  }

  @Override
  public String toString()
  {
    return m_file.getName();
  }

  private static boolean isExampleClass(Class<?> c)
  {
    try
    {
      c.getMethod("main", String[].class);
    }
    catch (NoSuchMethodException e)
    {
      return false;
    }
    return (Example.class.isAssignableFrom(c));
  }

  // List examples in sub-directories of the current directory
  private void makeExamplesList()
  {
    File[] dirs = listDir();

    for ( int i = 0; dirs != null && i < dirs.length; i++ )
    {
      // list of class files
      String[] classFiles = dirs[i].list(new ClassExtensionFilter());

      // build package name
      String packageName = "";
      File parentDir = dirs[i];

      while ( parentDir != null && !parentDir.getAbsolutePath().equals(DemosLauncher.ROOT_DIR) )
      {
        packageName = parentDir.getName() + "." + packageName;
        parentDir = parentDir.getParentFile();
      }

      for ( int j = 0; classFiles != null && j < classFiles.length; j++ )
      {
        String classname = packageName + classFiles[j].substring(0, classFiles[j].indexOf("."));

        // try to load class
        try
        {
          Class<?> c = ClassLoader.getSystemClassLoader().loadClass(classname);

          if ( c != null && isExampleClass(c) )
          {
            // sort list of examples by alphabetical order
            final int nbExamples = m_examplesClassList.size();
            final String newExampleName = dirs[i].getName();
            int index;

            for ( index = 0; index < nbExamples; index++ )
            {
              String name = m_examplesNameList.get(index);
              if ( name.compareToIgnoreCase(newExampleName) > 0 )
                break;
            }
            m_examplesClassList.add(index, classname);
            m_examplesNameList.add(index, newExampleName);
          }
        }
        catch (NoClassDefFoundError e)
        {}
        catch (ClassNotFoundException exc)
        {
          System.err.println(exc);
        }
      }
    }
  }

  public boolean expand(DefaultMutableTreeNode parent)
  {
    DefaultMutableTreeNode flag;
    try
    {
      flag = (DefaultMutableTreeNode) parent.getFirstChild();
    }
    catch (NoSuchElementException e)
    {
      // node has no children
      return false;
    }

    Object o = flag.getUserObject();
    if ( !(o instanceof Boolean) )
      // node already expanded
      return false;

    parent.removeAllChildren();
    File[] files = listDir();
    if ( files == null )
      // node has no directory
      return false;

    for ( int i = 0; i < files.length; i++ )
    {
      File f = files[i];
      DirTreeNode new_node = new DirTreeNode(f);
      DefaultMutableTreeNode nd = new DefaultMutableTreeNode(new_node);

      if ( new_node.getExamplesCount() != 0 || (new_node.listDir() != null && getExamplesCount() == 0) )
      {
        parent.add(nd);
        // mark new node for further expansion
        nd.add(new DefaultMutableTreeNode(Boolean.valueOf(true)));
      }
    }
    return true;
  }

  protected File[] listDir()
  {
    if ( !m_file.isDirectory() )
      return null;
    try
    {
      File[] files = m_file.listFiles(new DirFileFilter());
      if ( files.length == 0 )
        return null;
      Arrays.sort(files);
      return files;
    }
    catch (Exception e)
    {
      JOptionPane.showMessageDialog(null, "Error reading directory " + m_file.getAbsolutePath(), "Warning",
          JOptionPane.WARNING_MESSAGE);
      return null;
    }
  }
}
