//!oiv_include <VolumeViz/vvizfnc_frag.h>
//!oiv_include <VolumeViz/vvizGetData_frag.h>
//!oiv_include <VolumeViz/vvizTransferFunction_frag.h>

// uniform identifying the SoTexture2 node. the name of the uniform (MyTexture) must correspond to the name
// of SoShaderParameter1i attached to SoFragmentShader.
uniform float VVizGradientThreshold;

vec4 VVizComputeFragmentColor(VVizDataSetId dataset, vec3 rayDir, inout VVizVoxelInfo voxelInfoFront, in VVizVoxelInfo voxelInfoBack, int mask)
{
  vec3 texCoord = voxelInfoFront.texCoord;

  float x = texCoord.x;
  float fx = -16 * pow(x, 5) + 40 * pow(x, 4) - 32 * pow(x, 3) + 8 * pow(x, 2) + x;

 // if ( fx < 0.5 - alpha )
 // {
 //   fx = x * 0.5 / (0.5 - alpha);
 // }
 // else if ( 0.5 - alpha <= fx && fx <= 0.5 + alpha )
 //   fx = 0.5;
 // else
 // {
 //   fx = x * 0.5 / (0.5 - alpha) + (0.5 - 0.5 / (0.5 - alpha) * (0.5 + alpha));
 // }


  float elevation = texCoord.z * texCoord.z * texCoord.z;
  if ( elevation < 1.0 - 0.1*VVizGradientThreshold )
    elevation = 0.0;
  else
    elevation -= 1.0 - 0.1*VVizGradientThreshold;

  texCoord.x = mix(x, fx, elevation );

  float alpha = 0.15;// * VVizGradientThreshold;
  if ( abs(x - 0.5) < mix(0.0, alpha, elevation ) )
    return vec4(0.0);

  // get the data value at this position
  VVIZ_DATATYPE sf = VVizGetData(dataset, texCoord);
  // get the color for this value through the transfer function
  vec4 res = VVizTransferFunction(sf, 0);
  
  return res;
}

