package medical.tools.bonesMuscles;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.misc.callbacks.SoEventCallbackCB;
import com.openinventor.inventor.nodes.*;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaExaminer;
import com.openinventor.ldm.nodes.SoDataRange;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.medical.helpers.MedicalHelper;
import com.openinventor.medical.nodes.TextBox;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeRender;
import com.openinventor.volumeviz.nodes.SoVolumeRenderingQuality;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  public static final String EXAMPLE_NAME = "Bones Muscles";
  public static final String DATA = "/medical/data/files/medicalFoot.ldm";
  public static final String COLORMAPFILENAME = "/medical/data/resources/volrenGlow.am";

  private final static Logger LOGGER = Logger.getLogger(Main.class.getName());
  private boolean LeftMousePressed = false;
  private int HorizVal = 0;
  private int VertiVal = 0;

  private IRenderAreaExaminer _renderArea;

  private SoSeparator _root;
  private SoDataRange _localDataRange;
  private static String _dataFile;
  private static String _colorMap;

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain(EXAMPLE_NAME);
  }

  @Override
  public void start()
  {
    // Load example resources
    try
    {
      _dataFile = (new File(Main.class.getResource(DATA).toURI())).toString();
      _colorMap = (new File(Main.class.getResource(COLORMAPFILENAME).toURI())).toString();
    }
    catch (Exception e)
    {
      LOGGER.log(Level.SEVERE, "Failed to load resources", e);
      return;
    }

    buildSceneGraph();

    _renderArea = ViewerComponentsFactory.createRenderAreaExaminer();
    _renderArea.setSceneGraph(_root);
    _renderArea.viewAll(new SbViewportRegion(MedicalHelper.WINDOW_WIDTH, MedicalHelper.WINDOW_HEIGHT));

    final Component canvas = _renderArea.getComponent();
    canvas.setPreferredSize(new java.awt.Dimension(MedicalHelper.WINDOW_WIDTH, MedicalHelper.WINDOW_HEIGHT));
    setLayout(new BorderLayout());
    add(canvas);
  }

  @Override
  public void stop()
  {
    _renderArea.dispose();
  }

  private void buildSceneGraph()
  {
    // Create root node
    _root = new SoSeparator();

    SoSeparator dataSep = new SoSeparator();
    _root.addChild(dataSep);

    // Increase the rendering quality when you stop to move the dataset.
    SoInteractiveComplexity cplx = new SoInteractiveComplexity();
    cplx.setName("InteractiveComplexity");
    cplx.fieldSettings.set1(0, "SoComplexity value 0.3 0.7");
    cplx.fieldSettings.set1(1, "SoVolumeRender interpolation LINEAR CUBIC");
    cplx.refinementDelay.setValue(0);

    // Set the ambient, diffuse, transparency, specular and shininess of the
    // material
    SoMaterial material = new SoMaterial();
    material.ambientColor.setValue(.0f, .0f, .0f);
    material.diffuseColor.setValue(1.0f, 1.0f, 1.0f);
    material.transparency.setValue(0.0f);
    material.specularColor.setValue(1.0f, 1.0f, 1.0f);
    material.shininess.setValue(0.5f);
    dataSep.addChild(material);

    // All data under this group will be Shadowed
    SoShadowGroup dataToShadow = new SoShadowGroup();
    dataToShadow.method.setValue(SoShadowGroup.ShadowingMethods.VARIANCE_SHADOW_MAP);
    dataToShadow.intensity.setValue(0.7f);
    dataToShadow.smoothFactor.setValue(4);
    dataToShadow.isActive.setValue(true);
    dataSep.addChild(dataToShadow);

    // -----------------------------------------------------------------
    // Separator for the foot support.
    SoSeparator supportSep = new SoSeparator();
    dataToShadow.addChild(supportSep);

    SoTranslation supportTrans = new SoTranslation();
    supportTrans.translation.setValue(10.0f, 0.0f, 0.0f);
    supportSep.addChild(supportTrans);

    // Define Cube to represent the support
    SoCube support = new SoCube();
    supportSep.addChild(support);
    support.depth.setValue(50.0f);
    support.width.setValue(50.0f);
    support.height.setValue(0.05f);

    // Define Rotation transformation for Volume Data
    SoRotationXYZ rotX = new SoRotationXYZ();
    rotX.axis.setValue(SoRotationXYZ.AxisType.X);
    rotX.angle.setValue(-3.14f / 2);
    dataToShadow.addChild(rotX);

    SoRotationXYZ rotZ = new SoRotationXYZ();
    rotZ.axis.setValue(SoRotationXYZ.AxisType.Z);
    rotZ.angle.setValue(-3.14f / 2);
    dataToShadow.addChild(rotZ);

    // Node to hold the volume data
    SoVolumeData pVolData = new SoVolumeData();
    dataToShadow.addChild(pVolData);
    pVolData.ldmResourceParameters.getValue().tileDimension.setValue(128, 128, 128);
    pVolData.texturePrecision.setValue((short) 16);
    pVolData.fileName.setValue(_dataFile);

    // Set data default range.
    _localDataRange = new SoDataRange();
    dataToShadow.addChild(_localDataRange);
    _localDataRange.min.setValue(176);
    _localDataRange.max.setValue(476);

    // Load the colorMap from an Avizo colormap.
    SoTransferFunction pTransFunc = new SoTransferFunction();
    dataToShadow.addChild(pTransFunc);
    pTransFunc.loadColormap(_colorMap);

    // Property node which allows SoVolumeRender to draw High Quality volumes.
    SoVolumeRenderingQuality pVRVolQuality = new SoVolumeRenderingQuality();
    dataToShadow.addChild(pVRVolQuality);
    pVRVolQuality.preIntegrated.setValue(true);
    pVRVolQuality.ambientOcclusion.setValue(true);
    pVRVolQuality.deferredLighting.setValue(true);

    // Node in charge of drawing the volume
    SoVolumeRender pVolRender = new SoVolumeRender();
    dataToShadow.addChild(pVolRender);
    pVolRender.numSlicesControl.setValue(SoVolumeRender.NumSlicesControls.AUTOMATIC);
    pVolRender.samplingAlignment.setValue(SoVolumeRender.SamplingAlignments.BOUNDARY_ALIGNED);

    // Mouse event callback to manage data range
    SoEventCallback mouseEventCB = new SoEventCallback();
    mouseEventCB.addEventCallback("com.openinventor.inventor.events.SoMouseButtonEvent", new MousePressCB(), null);
    mouseEventCB.addEventCallback("com.openinventor.inventor.events.SoLocation2Event", new MouseMoveCB(), null);
    dataSep.addChild(mouseEventCB);

    // Add Open Inventor logo at the left-bottom corner
    SoNode logoBackground = null;
    try
    {
      logoBackground = MedicalHelper.getExampleLogoNode();
    }
    catch (FileNotFoundException e)
    {
      LOGGER.log(Level.SEVERE, "Failed to load logo", e);
    }
    _root.addChild(logoBackground);

    // Instructions
    TextBox textBox = new TextBox();
    textBox.position.setValue(0, 0.99f, 0); // Normalized Device Coordinates
                                            // (-1..1)
    textBox.alignmentV.setValue(TextBox.AlignmentV.TOP);
    textBox.alignmentH.setValue(TextBox.AlignmentH.CENTER);
    textBox.addLine("In selection mode :");
    textBox.addLine("  -> Drag horizontally with left mouse button pressed to change the min data range.");
    textBox.addLine("  -> Drag vertically with left mouse button pressed to change the max data range.");
    _root.addChild(textBox);

    textBox = new TextBox();
    textBox.position.setValue(0, -0.99f, 0); // Normalized Device Coordinates
                                             // (-1..1)
    textBox.alignmentV.setValue(TextBox.AlignmentV.BOTTOM);
    textBox.alignmentH.setValue(TextBox.AlignmentH.CENTER);
    textBox.addLine("Volume rendering with shadow casting");
    _root.addChild(textBox);
  }

  class MousePressCB extends SoEventCallbackCB
  {
    @Override
    public void invoke(SoEventCallback eventCB)
    {
      SoEvent evt = eventCB.getEvent();

      if ( SoMouseButtonEvent.isButtonPressEvent(evt, SoMouseButtonEvent.Buttons.BUTTON1) )
      {
        LeftMousePressed = true;
        HorizVal = evt.getPosition().getX();
        VertiVal = evt.getPosition().getY();
        eventCB.setHandled();
      }
      else
        LeftMousePressed = false;
    }
  }

  class MouseMoveCB extends SoEventCallbackCB
  {
    @Override
    public void invoke(SoEventCallback eventCB)
    {
      SoEvent evt = eventCB.getEvent();
      SbVec2s myPos = evt.getPosition();

      if ( LeftMousePressed )
      {
        double minVal = _localDataRange.min.getValue();
        if ( myPos.getX() > HorizVal )
          minVal += 20;
        if ( myPos.getX() < HorizVal )
          minVal -= 20;

        _localDataRange.min.setValue(minVal);
        HorizVal = myPos.getX();

        // -------------------------------------------------------------
        double maxVal = _localDataRange.max.getValue();
        if ( myPos.getY() > VertiVal )
          maxVal += 10;
        if ( myPos.getY() < VertiVal )
          maxVal -= 10;

        _localDataRange.max.setValue(maxVal);
        VertiVal = myPos.getY();
      }
      _localDataRange.touch();
    }
  }
}
