package medical.tools.rotateroi;

import java.awt.BorderLayout;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.openinventor.medical.helpers.MedicalHelper;

import util.Example;

public class Main extends Example
{
  public static final String DATA = "/medical/data/files/3DHEAD.ldm";
  public static final String EXAMPLE_NAME = "Rotate ROI";
  public static final String EXAMPLE_DESCRITPION = "This example shows how to clip a volume defined by a dragger";
  private final static Logger LOGGER = Logger.getLogger(Main.class.getName());

  private RotateRoiPanel m_examplePanel;

  public static void printHelp()
  {
    System.out.println("Launching example: " + EXAMPLE_NAME);
    System.out.println(EXAMPLE_DESCRITPION);
    System.out.println("LeftClick a face of the ROI to drag along two axis");
    System.out.println("LeftClick a 'white cube' to scale the ROI along all axis");
    System.out.println("LeftClick a 'green ball' to rotate the ROI around one axis");
    System.out.println("Shift+LeftClick a face of the ROI to drag along one axis only");
    System.out.println("Shift+LeftClick a 'white cube' to scale the ROI along one axis");
    System.out.println("Shift+LeftClick a 'green ball' to rotate the ROI around all axis");
  }

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain(EXAMPLE_NAME);
  }

  @Override
  public void start()
  {
    printHelp();

    // Load example resources
    File dataFile;
    try
    {
      dataFile = new File(Main.class.getResource(DATA).toURI());
    }
    catch (Exception e)
    {
      LOGGER.log(Level.SEVERE, "Failed to load resources", e);
      return;
    }

    // Set up UI
    m_examplePanel = new RotateRoiPanel(dataFile.toString());

    setPreferredSize(new java.awt.Dimension(MedicalHelper.WINDOW_WIDTH, MedicalHelper.WINDOW_HEIGHT));
    setLayout(new BorderLayout());
    add(m_examplePanel);
  }

  @Override
  public void stop()
  {
    m_examplePanel.destroy();
  }
}
