package medical.web.simplemedicalremote.service;

import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer;
import com.openinventor.medical.helpers.MedicalHelper;
import com.openinventor.remoteviz.rendering.RenderArea;
import com.openinventor.remoteviz.rendering.RenderAreaListener;
import com.openinventor.remoteviz.rendering.ServiceListener;

public class SimpleMedicalRemoteServiceListener extends ServiceListener
{
  private final static Logger LOGGER = Logger.getLogger(SimpleMedicalRemoteServiceListener.class.getName());
  private final String m_ivFilePath;

  public SimpleMedicalRemoteServiceListener(String ivFilePath)
  {
    super();
    m_ivFilePath = ivFilePath;
  }

  @Override
  public void onInstantiatedRenderArea(RenderArea renderArea)
  {
    RenderAreaListener renderAreaListener = new RenderAreaListener();
    renderArea.addListener(renderAreaListener);
    renderArea.getTouchManager().addDefaultRecognizers();

    SceneExaminer sceneExaminer = new SceneExaminer();

    SoInput myInput = new SoInput();
    if ( myInput.openFile(m_ivFilePath) == true )
    {
      sceneExaminer.addChild(SoDB.readAll(myInput));

      try
      {
        // OIV Logo
        SoNode logoBackground = MedicalHelper.getExampleLogoNode();
        sceneExaminer.addChild(logoBackground);
      }
      catch (FileNotFoundException e)
      {
        LOGGER.log(Level.SEVERE, "Failed to load logo", e);
      }
      renderArea.getSceneManager().setSceneGraph(sceneExaminer);
      sceneExaminer.viewAll(renderArea.getSceneManager().getViewportRegion());
    }
    else
    {
      LOGGER.log(Level.SEVERE, "Failed to load file: " + m_ivFilePath);
    }
  }
}
