package meshviz.graph.advanced.autoCubeAxis;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoEnvironment;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoAutoCubeAxis;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Auto Cube Axis");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    PoDomain domain = new PoDomain();
    domain.min.setValue(0, 0, 0);
    domain.max.setValue(1, 10, 100);

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New");

    SoEnvironment environment = new SoEnvironment() ;
    environment.ambientIntensity.setValue(1.5F) ;

    PoAutoCubeAxis autoCubeAxis = new PoAutoCubeAxis(new SbVec3f(0,0,0), new SbVec3f(1,10,100),
						     PoAutoCubeAxis.AxisTypes.LINEAR,
						     PoAutoCubeAxis.AxisTypes.LINEAR,
						     PoAutoCubeAxis.AxisTypes.LINEAR,
						     "X", "Y", "Z") ;
    autoCubeAxis.set("backgroundFaceApp.material", "diffuseColor 1 0 0") ;
    autoCubeAxis.isBackgroundFacesVisible.setValue(true) ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(domain);
      root.addChild(textAttr);
      root.addChild(environment);
      root.addChild(autoCubeAxis);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
