package meshviz.graph.advanced.multipleAxis;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoCube;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoTransformSeparator;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoCartesianAxis.Types;
import com.openinventor.meshviz.graph.PoLinearAxis;
import com.openinventor.meshviz.graph.PoRectangle;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

   private IViewerExaminer myViewer;

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Multiple Axis");
   }

   @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    //  domain 1
    PoDomain domain1 = new PoDomain();
    domain1.min.setValue(50,0,0);
    domain1.max.setValue(100,0.1F,1);

    // domain2
    PoDomain domain2 = new PoDomain();
    domain2.min.setValue(50,5,0);
    domain2.max.setValue(100,10,1);

    // domain3
    PoDomain domain3 = new PoDomain();
    domain3.min.setValue(50,-3,0);
    domain3.max.setValue(100,-2,1);

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New") ;

    PoLinearAxis linAxisX = new PoLinearAxis() ;
    linAxisX.titleVisibility.setValue(PoLinearAxis.Visibilities.VISIBILITY_ON) ;
    linAxisX.titleString.setValue("X-Axis") ;
    linAxisX.start.setValue(50, 5, 0) ;
    linAxisX.end.setValue(100) ;

    PoLinearAxis linAxisY = new PoLinearAxis(new SbVec3f(50,5,0), 10, Types.YX, 0) ;
    PoLinearAxis linAxis2Y = new PoLinearAxis(new SbVec3f(40,0,0), 0.1F, Types.YX, 0) ;
    PoLinearAxis linAxis3Y = new PoLinearAxis(new SbVec3f(30,-3,0), -2, Types.YX, 0) ;

    PoRectangle rect = new PoRectangle(new SbVec2f(60, 6), new SbVec2f(70, 7.5F)) ;
    PoRectangle rect2 = new PoRectangle(new SbVec2f(90, 0.05F), new SbVec2f(95, 0.08F)) ;
    PoRectangle rect3 = new PoRectangle(new SbVec2f(65, -2.4F), new SbVec2f(70, -2.1F)) ;

    SoTranslation translate = new SoTranslation() ;
    translate.translation.setValue(80, 7, 0) ;
    SoCube cube = new SoCube() ;
    cube.width.setValue(10) ;
    cube.height.setValue(1) ;
    cube.depth.setValue(0.02F) ;

    SoTranslation translate2 = new SoTranslation() ;
    translate2.translation.setValue(0, 50, 0) ;

    SoTransformSeparator transSep = new SoTransformSeparator() ;
    transSep.addChild(translate2) ;
    transSep.addChild(linAxis2Y) ;
    transSep.addChild(rect2) ;
    linAxis2Y.set("bodyApp.material", "diffuseColor 1 0 0") ;
    rect2.set("appearance.material", "diffuseColor 1 0 0") ;

    SoTranslation translate3 = new SoTranslation() ;
    translate3.translation.setValue(0, 200, 0) ;

    SoTransformSeparator transSep2 = new SoTransformSeparator() ;
    transSep2.addChild(translate3) ;
    transSep2.addChild(linAxis3Y) ;
    transSep2.addChild(rect3) ;
    linAxis3Y.set("bodyApp.material", "diffuseColor 0 1 0") ;
    rect3.set("appearance.material", "diffuseColor 0 1 0") ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(textAttr);
      root.addChild(domain2);
      root.addChild(rect);
      root.addChild(linAxisX);
      root.addChild(linAxisY);
      root.addChild(domain1);
      root.addChild(transSep);
      root.addChild(domain3);
      root.addChild(transSep2);
      root.addChild(domain2.getTransform());
      root.addChild(translate);
      root.addChild(cube);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
