// AnimatedDataExample : curve and timer sensor
package meshviz.graph.mentor.animatedDataExample;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Random;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.sensors.SoTimerSensor;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoCurve;
import com.openinventor.meshviz.graph.PoGroup2Axis;
import com.openinventor.meshviz.nodes.PoDomain;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private static final int NUM_POINTS = 50;

  private IViewerExaminer myViewer;
  SbVec2f[] points;
  PoCurve myCurve;
  PoDomain myDom;
  PoGroup2Axis my2Axis;
  int currentPointIndex;
  Random rand;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Animated Data Example");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    // Create the curve
    myCurve = new PoCurve();
    points = new SbVec2f[NUM_POINTS];
    for(int i=0; i<NUM_POINTS; i++)
      points[i]= new SbVec2f(0, 0);

    myCurve.point.setNum(0);
    myCurve.set("curvePointApp.material", "diffuseColor [1 0 0]");

    // Create a group of 2 axis
    my2Axis = new PoGroup2Axis();
    my2Axis.end.setValue(new SbVec2f(50, 50));
    my2Axis.xTitle.setValue("Randomize");
    my2Axis.set("appearance.material", "diffuseColor 0 0 0") ;

    myDom = new PoDomain();
    myDom.min.setValue(new SbVec3f(0, 0, 0));
    myDom.max.setValue(new SbVec3f(50, 50, 0));

    SbColor bkgColor = new SbColor(Color.WHITE);
    SoGradientBackground background = new SoGradientBackground();
    background.color0.setValue(bkgColor);
    background.color1.setValue(bkgColor);

    // Create the root of the scene graph
    SoAnnotation root = new SoAnnotation();
    { // assemble scene graph
      root.addChild(background);
      root.addChild(myDom);
      root.addChild(my2Axis);
      root.addChild(myCurve);
    }

    currentPointIndex = 0;
    rand = new Random(0);
    SoTimerSensor schedulingSensor =
      new SoTimerSensor(new newPointTask());
    schedulingSensor.setInterval(new SbTime(0.03));
    schedulingSensor.schedule();

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  // inner classes to declare callbacks
  class newPointTask implements Runnable {
    @Override
    public void run() {
      int i;
      float newy,ymax;

      newy = (float)(50. * rand.nextFloat());
      points[currentPointIndex].setValue(currentPointIndex, newy);
      if(currentPointIndex == NUM_POINTS - 1) {
        currentPointIndex=0 ;
        myCurve.point.setNum(0) ;
      }
      else {
        currentPointIndex++ ;
        SbVec2f visiblePoints[] = new SbVec2f[currentPointIndex];
        ymax = newy;
        for (i=0; i < currentPointIndex; i++) {
          visiblePoints[i] = points[i];
          float[] pt = points[i].getValue();
          ymax = Math.max(ymax, pt[1]);
        }
        myDom.max.setValue(new SbVec3f(NUM_POINTS, ymax,0));
        my2Axis.end.setValue(new SbVec2f(NUM_POINTS, ymax));
        myCurve.point.setValues(0, visiblePoints);
      }
    }
  }
}
