// Axis3dExample : 3D curve and axis group
package meshviz.graph.mentor.axis3dExample;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoCurve3;
import com.openinventor.meshviz.graph.PoGroup6Axis3;
import com.openinventor.meshviz.graph.PoGroup6Axis3.AxisTypes;
import com.openinventor.meshviz.nodes.PoDomain;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private static final int NUM_POINTS = 50;

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Axis 3D Example");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Create the curve
    double ang, radius;
    int i;
    PoCurve3 myCurve = new PoCurve3();
    SbVec3f[] points = new SbVec3f[NUM_POINTS];
    ang = 0;
    radius = 0;
    for (i = 0; i < NUM_POINTS; i++, ang += 6 * Math.PI / NUM_POINTS,
         radius += 10 / (double) NUM_POINTS)
      points[i] = new SbVec3f((float) (radius * Math.cos(ang)),
                              (float) (radius * Math.sin(ang)),
                              (float) (2 * radius));
    myCurve.point.setValues(0, points);
    myCurve.set("curvePointApp.material", "diffuseColor [1 0 0]");
    myCurve.set("curvePointApp.drawStyle", "linewidth 3.");

    // Create the group of axis
    PoGroup6Axis3 my6Axis =
        new PoGroup6Axis3(new SbVec3f( -10, -10, 0), new SbVec3f(10, 10, 20),
                          AxisTypes.LINEAR,
                          AxisTypes.LINEAR,
                          AxisTypes.LINEAR);
    my6Axis.set("appearance.material", "diffuseColor 0 0 0");

    // Define domain of curve and its axis.
    PoDomain myDom = new PoDomain();
    myDom.min.setValue(new SbVec3f( -10, -10, 0));
    myDom.max.setValue(new SbVec3f(10, 10, 20));

    SbColor bkgColor = new SbColor(Color.WHITE);
    SoGradientBackground background = new SoGradientBackground();
    background.color0.setValue(bkgColor);
    background.color1.setValue(bkgColor);

    // Create the root of the scene graph
    SoSeparator root = new SoSeparator();
    { // assemble scene graph
      root.addChild(background);
      root.addChild(myDom);
      root.addChild(myCurve);
      root.addChild(my6Axis);
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
