// LegendExample2 : 3 curves with legends, examiner viewer
package meshviz.graph.mentor.legendExample2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoCartesianAxis;
import com.openinventor.meshviz.graph.PoCurve;
import com.openinventor.meshviz.graph.PoItemLegend;
import com.openinventor.meshviz.graph.PoLinearAxis;
import com.openinventor.meshviz.nodes.PoDomain;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private static final int NUM_POINTS = 50;

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Legend Example 2");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Create the legend
    String[] items = { "sin(x)", "cos(x)", "sin(x)*cos(x)"};
    SbColor[] colors = { new SbColor(1, 0, 0),
                         new SbColor(0, 1, 0),
                         new SbColor(0, 0, 1) };
    PoItemLegend myLegend = new PoItemLegend(new SbVec2f(-10 ,7),
                                             new SbVec2f(-3, 2),
                                             items,colors);

    myLegend.set("backgroundApp.material", "diffuseColor 1 1 1") ;
    myLegend.set("backgroundBorderApp.material", "diffuseColor 0 0 0") ;
    myLegend.set("boxBorderApp.material", "diffuseColor 0 0 0") ;
    myLegend.set("valueTextApp.material", "diffuseColor 0 0 0") ;


    // Create  X  axis
    PoLinearAxis myXAxis = new PoLinearAxis();
    myXAxis.set("appearance.material", "diffuseColor 0 0 0") ;
    myXAxis.start.setValue(new SbVec3f(0, -1, 0));
    myXAxis.end.setValue((float)(4*Math.PI));
    myXAxis.type.setValue(PoCartesianAxis.Types.XY);

    // Create Y axis
    PoLinearAxis myYAxis = new PoLinearAxis();
    myYAxis.set("appearance.material", "diffuseColor 0 0 0") ;
    myYAxis.start.setValue(new SbVec3f(0, -1, 0));
    myYAxis.end.setValue(1);
    myYAxis.type.setValue(PoCartesianAxis.Types.YX);

    // Create the curves
    double ang;
    int i;
    SbVec2f[] points1 = new SbVec2f[NUM_POINTS];
    for(i=0, ang=0; i<NUM_POINTS; i++, ang += 4*Math.PI/NUM_POINTS)
      points1[i] = new SbVec2f((float)ang, (float)Math.sin(ang));
    PoCurve myCurve1 = new PoCurve();
    myCurve1.point.setValues(0, points1);
    myCurve1.set("curvePointApp.material", "diffuseColor [1 0 0]");

    SbVec2f[] points2 = new SbVec2f[NUM_POINTS];
    for(i=0, ang=0; i<NUM_POINTS; i++, ang += 4*Math.PI/NUM_POINTS)
      points2[i] = new SbVec2f((float)ang, (float)Math.cos(ang));
    PoCurve myCurve2 = new PoCurve();
    myCurve2.point.setValues(0, points2);
    myCurve2.set("curvePointApp.material", "diffuseColor [0 1 0]");

    SbVec2f[] points3 = new SbVec2f[NUM_POINTS];
    for(i=0, ang=0; i<NUM_POINTS; i++, ang += 4*Math.PI/NUM_POINTS)
      points3[i] = new SbVec2f((float)ang, (float)(Math.sin(ang)*Math.cos(ang)));
    PoCurve myCurve3 = new PoCurve();
    myCurve3.point.setValues(0, points3);
    myCurve3.set("curvePointApp.material", "diffuseColor [0 0 1]");

    PoDomain myDom = new PoDomain();
    myDom.min.setValue(new SbVec3f(0,-1,0));
    myDom.max.setValue(new SbVec3f((float)(4*Math.PI), 1, 0));

    SbColor bkgColor = new SbColor(Color.WHITE);
    SoGradientBackground background = new SoGradientBackground();
    background.color0.setValue(bkgColor);
    background.color1.setValue(bkgColor);

    // Create the root of the scene graph
    SoAnnotation root = new SoAnnotation();
    { // assemble scene graph
      root.addChild(background);
      root.addChild(myLegend);
      root.addChild(myDom);
      root.addChild(myXAxis);
      root.addChild(myYAxis);
      root.addChild(myCurve1);
      root.addChild(myCurve2);
      root.addChild(myCurve3);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
