// WriteFormatExample
package meshviz.graph.mentor.writeFormatExample;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

import com.openinventor.inventor.actions.SoWriteAction;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoBase;
import com.openinventor.meshviz.graph.PoRectangle;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  Frame m_fileFrame = null;
  String m_outFilename = "rectangle.iv";

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Write Format Example");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Remove the following line to output using FOLD format
    PoBase.setNodeWriteFormat(PoBase.NodeWriteFormats.UNFOLD_NODE_WRITE_FORMAT);

    PoRectangle myRectangle = new PoRectangle();

    final SoSeparator root = new SoSeparator();
    root.addChild(myRectangle) ;

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    JButton button = new JButton("Write rectangle.iv");
    button.setSelected(false);
    button.setBorder(BorderFactory.createRaisedBevelBorder());
    button.addMouseListener(new MouseAdapter() {
      @Override
      public void mousePressed(MouseEvent e) {
        SoWriteAction myAction = new SoWriteAction();
        myAction.getOutput().openFile(m_outFilename);
        myAction.getOutput().setBinary(false);
        myAction.apply(root);
        myAction.getOutput().closeFile();
        if (m_fileFrame == null)
          makeFileFrame();
      }
    });

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(button, BorderLayout.SOUTH);
  }

  @Override
  public void stop()
  {
    if ( m_fileFrame != null && m_fileFrame.isDisplayable() )
      m_fileFrame.dispose();
    myViewer.dispose();
  }

  private void makeFileFrame() {
    WindowListener l = new WindowAdapter() {
      @Override
      public void windowClosing(WindowEvent e) {
        e.getWindow().dispose();
      }
    };

    try {
      JEditorPane pane = new JEditorPane("file:" + m_outFilename);
      pane.setEditable(false);
      JScrollPane jsp = new JScrollPane(pane);
      jsp.setPreferredSize(new Dimension(750, 700));
      m_fileFrame = new Frame("Rectangle.iv");
      m_fileFrame.addWindowListener(l);
      m_fileFrame.add(jsp);
      m_fileFrame.pack();
      m_fileFrame.setVisible(true);
    }
    catch (Exception e) {
      System.out.println(e);
    }
  }
}

