package meshviz.graph.sample.errorCurve;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoErrorCurve;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private static SbVec2f[] point = {
      new SbVec2f(0.5F,5),    new SbVec2f(1.5F,6.5F), new SbVec2f(2.5F,7),
      new SbVec2f(3,6.5F),    new SbVec2f(3.5F,6),    new SbVec2f(4.5F,5.5F),
      new SbVec2f(5.5F,6.5F), new SbVec2f(6,7.5F),    new SbVec2f(6.5F,7),
      new SbVec2f(7.5F,6),    new SbVec2f(8.5F,5),    new SbVec2f(9.5F,4.5F)} ;

  private static float[] lowYR = {
      0.5F, 0.6F, 0.8F, 1, 0.3F, 0.7F, 0.8F, 1.2F, 0.4F, 0.6F, 0.8F, 1.2F} ;
  private static float[] highYR = {
      1, 0.5F, 0.6F, 1.2F, 0.5F, 1, 0.4F, 0.3F, 1.5F, 0.2F, 0.7F, 0.9F} ;

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    PoErrorCurve errCurve = new PoErrorCurve(point, lowYR, highYR) ;

    errCurve.errorCurveRep.setValue(PoErrorCurve.ErrorCurveReps.FILLED) ;
    errCurve.set("errorCurve1App.material", "diffuseColor [1 0 0]") ;

    errCurve.set("errorCurve2App.material", "diffuseColor [0 1 0]") ;
    errCurve.set("errorCurve3App.material", "diffuseColor [0 0 1]") ;
    errCurve.set("errorCurve4App.material", "diffuseColor [1 1 0]") ;
    errCurve.set("errorCurve5App.material", "diffuseColor [0 1 1]") ;

    SoAnnotation root = new SoAnnotation() ;
    root.addChild(errCurve) ;

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Error Curve");
  }
}
