package meshviz.graph.sample.errorPointField;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoErrorPointField;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private static SbVec2f[] point =
  {new SbVec2f(0.5F,0.5F), new SbVec2f(1.5F,3.8F), new SbVec2f(1.8F,1.2F), new SbVec2f(2.4F,1.9F),
   new SbVec2f(3.2F,6.3F), new SbVec2f(4.5F,7.2F), new SbVec2f(6.3F,9.3F), new SbVec2f(6.9F,7.2F),
   new SbVec2f(8,6),       new SbVec2f(8.5F,6.3F), new SbVec2f(9,7.5F),    new SbVec2f(9.2F,8.1F)} ;

  private static float[] errorX =
  {0.4F, 0.5F, 0.5F, 0.25F, 1, 0.25F, 0.5F, 0.25F, 0.5F, 0.25F, 0.5F, 0.25F} ;
  private static float[] errorY =
  {0.4F, 1.5F, 0.25F, 0.5F, 0.5F, 0.5F, 0.25F, 0.5F, 0.25F, 0.5F, 0.25F, 0.5F} ;

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    PoErrorPointField errPtFld = new PoErrorPointField(point, errorX, errorY) ;
//    errPtFld.shapeType.setValue(PoErrorPointField.ELLIPSE_SHAPE) ;
//	System.out.println("errPtFld.shapeType"+ errPtFld.shapeType.getValue());
 //   errPtFld.skeletonType.setValue(PoErrorPointField.CROSS3_SKELETON) ;
//	System.out.println("errPtFld.skeletonType"+ errPtFld.skeletonType.getValue());

    errPtFld.set("shapeApp.material", "diffuseColor [0 0 1]") ;
    errPtFld.set("skeletonApp.material", "diffuseColor [1 0 0]") ;

    SoAnnotation root = new SoAnnotation() ;
    root.addChild(errPtFld) ;

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Error Point Field");
  }
}
