package meshviz.graph.sample.generalizedBar;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.nodes.SoCylinder;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoGeneralizedBar;
import com.openinventor.meshviz.graph.PoGroup2Axis;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;
import com.openinventor.meshviz.nodes.PoRegularMesh1D;

import util.Example;
import util.ViewerComponentsFactory;

/*----------------------------------------------------------------------------*/

public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    float y[] = {0.5F, 3.8F, 1.2F, 7.2F, 9.3F, 7.2F, 6.0F, 7.5F, 4.1F, 1.5F}  ;

    myViewer = ViewerComponentsFactory.createViewerExaminer();

    PoDomain myDomain = new PoDomain();
    myDomain.min.setValue(0, 0, 0) ;
    myDomain.max.setValue(10, 10, 10) ;

    PoMiscTextAttr myTextAttr = new PoMiscTextAttr();
    myTextAttr.fontName.setValue("Courier New" );

    SoSeparator root = new SoSeparator();

    PoRegularMesh1D mesh1D = new PoRegularMesh1D();
    mesh1D.setGeometry(y.length, 0.5F, 9.5F) ;
    mesh1D.addValuesSet(0, y) ;

    // There are 3 possible shapes for the bars
    // which are a cone, a cylinder and
    // a queen (stored in an IV file).
    SoSeparator coneSep = new SoSeparator();
    coneSep.addChild(new SoCone()) ;

    SoSeparator cylinderSep = new SoSeparator();
    cylinderSep.addChild(new SoCylinder()) ;

    /*
      SoInput input = new SoInput() ;
      input.openFile("../../../data/flower.iv") ;
      SoSeparator queenSep = SoDB.readAll(input) ;
      input.closeFile() ;
      SoScale scale = new SoScale();
      scale.scaleFactor.setValue(70,70,70) ;
      queenSep.insertChild(scale, 0) ;
    */
    PoGeneralizedBar generalizedBar = new PoGeneralizedBar();
    generalizedBar.threshold.setValue(5 );
    generalizedBar.scaleFactor.setValue(0.35F, 0.35F, 0.35F) ;
    generalizedBar.bars.set1Value(0, coneSep) ;
    generalizedBar.bars.set1Value(1, cylinderSep) ;
    //  generalizedBar.bars.set1Value(2, queenSep) ;

    PoGroup2Axis g2Axis = new
      PoGroup2Axis(new SbVec2f(0,0), new SbVec2f(10, 10),
                   PoGroup2Axis.AxisTypes.LINEAR,
                   PoGroup2Axis.AxisTypes.LINEAR,
                   "X-Axis", "Y-Axis") ;

    SoMaterial material = new SoMaterial();
    material.ambientColor.setValue(1,1,1) ;
    material.diffuseColor.setValue(1,0,0) ;
    material.specularColor.setValue(1,1,1) ;
    material.shininess.setValue(0.8F) ;

    { // assemble scene graph
      root.addChild(myDomain);
      root.addChild(mesh1D);
      root.addChild(myTextAttr);
      root.addChild(g2Axis);
      root.addChild(material);
      root.addChild(generalizedBar);
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("GeneralizedBar");
  }


}

