package meshviz.graph.sample.group3Axis3;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoGroup3Axis3;
import com.openinventor.meshviz.graph.PoLinearAxis;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    PoDomain domain = new PoDomain();
    domain.min.setValue(0,0,0);
    domain.max.setValue(1, 10, 100);

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New") ;

    PoGroup3Axis3 g3Axis = new PoGroup3Axis3(new SbVec3f(0,0,0), new SbVec3f(1,10,100),
					   PoGroup3Axis3.AxisTypes.LINEAR,
					   PoGroup3Axis3.AxisTypes.LINEAR,
					   PoGroup3Axis3.AxisTypes.LINEAR,
					   PoGroup3Axis3.AxisNames.Z_AXIS, "X", "Y", "Z") ;
    g3Axis.verticalAxisName.setValue(PoGroup3Axis3.AxisNames.Y_AXIS) ;

    PoLinearAxis xAxis = (PoLinearAxis)g3Axis.getPart("xAxis", true);
    PoLinearAxis yAxis = (PoLinearAxis)g3Axis.getPart("yAxis", true);
    PoLinearAxis zAxis = (PoLinearAxis)g3Axis.getPart("zAxis", true);

    xAxis.set("bodyApp.material", "diffuseColor 1 0 0") ;
    yAxis.set("bodyApp.material", "diffuseColor 1 0 0") ;
    zAxis.set("bodyApp.material", "diffuseColor 1 0 0") ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(domain);
      root.addChild(textAttr);
      root.addChild(g3Axis) ;
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Group 3 Axis 3");
  }
}
