package meshviz.graph.sample.rectangle;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.engines.SoComposeVec2f;
import com.openinventor.inventor.engines.SoElapsedTime;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoRectangle;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    PoRectangle rect = new PoRectangle() ;
    PoRectangle rect2 = new PoRectangle(new SbVec2f(-2,-2), new SbVec2f(-1.5F,-1)) ;
    rect.q.setValue(2,1) ;

    SoElapsedTime counter = new SoElapsedTime();
    SoComposeVec2f compVec2f = new SoComposeVec2f() ;
    counter.speed.setValue(0.1F) ;
    compVec2f.x.connectFrom(counter.timeOut) ;
    compVec2f.y.connectFrom(counter.timeOut) ;
    rect.q.connectFrom(compVec2f.vector);

    SoSeparator root = new SoSeparator() ;
    root.addChild(rect) ;
    root.addChild(rect2) ;

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Rectangle");
  }
}
