//
// PoSceneView
////////////////////////////////
package meshviz.graph.sample.sceneView;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.gui.view.PoSceneView;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoCube;
import com.openinventor.inventor.nodes.SoDirectionalLight;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoPerspectiveCamera;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSphere;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

/*----------------------------------------------------------------------------*/
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Build the first view
    SoSeparator scene1 = new SoSeparator();
    SoMaterial cubeMaterial = new SoMaterial();
    cubeMaterial.diffuseColor.setValue(0,0,1);
    {
      scene1.addChild(cubeMaterial);
      scene1.addChild(new SoCube());
    }

    SoCamera viewerCamera = myViewer.getRenderArea().getSceneInteractor().getCamera();
    PoSceneView view1 = new PoSceneView() ;
    view1.isBorderVisible.setValue(true);
    view1.viewportOrigin.setValue(0, 0) ;
    view1.viewportSize.setValue(0.5f, 0.5f) ;
    view1.setPart("cameraKit.camera", viewerCamera) ;
    view1.setPart("scene", scene1) ;
    viewerCamera.viewAll(scene1, new SbViewportRegion((short)100, (short)100)) ;

    // Build the second view
    SoSeparator scene2 = new SoSeparator();
    SoMaterial sphereMaterial = new SoMaterial();
    sphereMaterial.diffuseColor.setValue(0,1,0);
    {
      scene2.addChild(sphereMaterial);
      scene2.addChild(new SoSphere());
    }

    PoSceneView view2 = new PoSceneView() ;
    view2.isBorderVisible.setValue(true);
    view2.viewportOrigin.setValue(0.5f, 0.5f) ;
    view2.viewportSize.setValue(0.5f, 0.5f) ;
    SoPerspectiveCamera camera2 = new SoPerspectiveCamera();
    view2.setPart("cameraKit.camera", camera2) ;
    view2.setPart("scene", scene2) ;
    camera2.viewAll(scene2, new SbViewportRegion((short)100, (short)100)) ;

    SoDirectionalLight dirLight = new SoDirectionalLight();
    dirLight.direction.setValue( 0.2F, -0.2F, -1.F) ;

    SoSeparator root = new SoSeparator();
    { // assemble scene graph
      root.addChild(dirLight);

      root.addChild(view1);
      root.addChild(view2);
    }

    myViewer.getRenderArea().getSceneInteractor().enableHeadlight(false);
    myViewer.setSceneGraph(root);

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Scene View");
  }

}/*---------------------------------------------------------------------------*/


