package meshviz.mesh.advanced.CartesianGrid3D;

import java.awt.BorderLayout;

import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.nodes.PoCartesianGrid3D;

import meshviz.mesh.advanced.meshViewer.MeshViewer;
import util.Example;

public class Main extends Example
{
  private static final float RADIUS_MIN = 1.f;
  private static final float RADIUS_MAX = 4.f;
  private static final float NUM_ROUND = 0.5f;
  private static final int NUM_DATASET = 10;
  private static final int NUM_X = 30;
  private static final int NUM_Y = 30;
  private static final int NUM_Z = 30;
  private float[] x;
  private float[] y;
  private float[] z;

  private float v[][];

  private PoCartesianGrid3D m_mesh;
  private MeshViewer m_meshViewer;

  public Main() {
    x = new float[NUM_X*NUM_Y*NUM_Z];
    y = new float[NUM_X*NUM_Y*NUM_Z];
    z = new float[NUM_X*NUM_Y*NUM_Z];
    v = new float[NUM_DATASET][NUM_X * NUM_Y * NUM_Z];
  }

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("PbCartesianGrid3D");
  }

  @Override
  public void start() {

    String[] data_names = {
        "X",
        "Y",
        "Z",
        "X*X + Y*Y + Z*Z",
        "X*X + Y + Z*Z*Z",
        "X*X + 5Y + Z*Z",
        "X*X + Y*Y*Y + Z*Z*Z*Z",
        "X*X*Y + Z",
        "X*X*Y*Y + Z*X",
        "X*Y*Z"
    };

    m_mesh = new PoCartesianGrid3D();
    build_mesh();
    compute_data();

    for (int i = 0; i < NUM_DATASET; i++)
      m_mesh.addValuesSet(i, v[i], data_names[i]);

    m_meshViewer = new MeshViewer();
    final IViewerExaminer viewer = m_meshViewer.show(m_mesh);

    setLayout(new BorderLayout());
    add(viewer.getComponent());
  }

  @Override
  public void stop()
  {
    m_meshViewer.stop();
  }

  private void build_mesh() {
    float xmin, ymin, zmin, xmax, ymax, zmax;
    float tmin = 0;
    float tmax = NUM_ROUND * 2.f * (float)Math.PI;
    zmin = 0;
    zmax = zmin + RADIUS_MAX * 2.f;

    float helice_ht = (zmax - zmin) / (NUM_ROUND * 2.5f);
    float delta_zk = helice_ht / (NUM_Z - 1);
    float delta_zj = (zmax - helice_ht - zmin) / (NUM_Y - 1);

    float[] r = new float[NUM_X];
    float[] t = new float[NUM_Y];
    float[] zt = new float[NUM_Y];

    float delta_r = (RADIUS_MAX - RADIUS_MIN) / (NUM_X - 1);
    float delta_t = (tmax - tmin) / (NUM_Y - 1);

    for (int i = 0; i < NUM_X; i++)
      r[i] = RADIUS_MIN + i * delta_r;
    for (int j = 0; j < NUM_Y; j++)
      t[j] = tmin + j * delta_t;
    for (int j = 0; j < NUM_Y; j++)
      zt[j] = zmin + j * delta_zj;

    xmin = ymin = zmin = 1.0E30F;
    xmax = ymax = zmax = -1.0E30F;

    for (int i = 0; i < NUM_X; i++)
      for (int j = 0; j < NUM_Y; j++)
        for (int k = 0; k < NUM_Z; k++) {
          x[i*NUM_Y*NUM_Z + j*NUM_Z + k] = r[i] * (float)Math.cos(t[j]);
          if (xmax < x[i*NUM_Y*NUM_Z + j*NUM_Z + k])
            xmax = x[i*NUM_Y*NUM_Z + j*NUM_Z + k];
          if (xmin > x[i*NUM_Y*NUM_Z + j*NUM_Z + k])
            xmin = x[i*NUM_Y*NUM_Z + j*NUM_Z + k];
        }

    for (int i = 0; i < NUM_X; i++)
      for (int j = 0; j < NUM_Y; j++)
        for (int k = 0; k < NUM_Z; k++) {
          y[i*NUM_Y*NUM_Z + j*NUM_Z + k] = r[i] * (float)Math.sin(t[j]);
          if (ymax < y[i*NUM_Y*NUM_Z + j*NUM_Z + k])
            ymax = y[i*NUM_Y*NUM_Z + j*NUM_Z + k];
          if (ymin > y[i*NUM_Y*NUM_Z + j*NUM_Z + k])
            ymin = y[i*NUM_Y*NUM_Z + j*NUM_Z + k];
        }

    for (int i = 0; i < NUM_X; i++)
      for (int j = 0; j < NUM_Y; j++) {
        z[i*NUM_Y*NUM_Z + j*NUM_Z] = zt[j];
        if (zmax < z[i*NUM_Y*NUM_Z + j*NUM_Z])
          zmax = z[i*NUM_Y*NUM_Z + j*NUM_Z];
        if (zmin > z[i*NUM_Y*NUM_Z + j*NUM_Z])
          zmin = z[i*NUM_Y*NUM_Z + j*NUM_Z];
        for (int k = 1; k < NUM_Z; k++) {
          z[i*NUM_Y*NUM_Z + j*NUM_Z + k] = z[i*NUM_Y*NUM_Z + j*NUM_Z + k-1] + delta_zk;
          if (zmax < z[i*NUM_Y*NUM_Z + j*NUM_Z + k])
            zmax = z[i*NUM_Y*NUM_Z + j*NUM_Z + k];
          if (zmin > z[i*NUM_Y*NUM_Z + j*NUM_Z + k])
            zmin = z[i*NUM_Y*NUM_Z + j*NUM_Z + k];
        }
      }

    m_mesh.setGeometry(NUM_X, NUM_Y, NUM_Z, x, y, z);
  }

  private void compute_data() {
    float xc, yc, zc;
    float[] xt = new float[NUM_X];
    float[] yt = new float[NUM_Y];
    float[] zt = new float[NUM_Z];

    float xmin, ymin, zmin, xmax, ymax, zmax;
    xmin = ymin = zmin = -2.f;
    xmax = ymax = zmax = 2.f;
    for (int i = 0; i < NUM_X; i++)
      xt[i] = xmin + i * (xmax - xmin) / (NUM_X - 1);
    for (int j = 0; j < NUM_Y; j++)
      yt[j] = ymin + j * (ymax - ymin) / (NUM_Y - 1);
    for (int k = 0; k < NUM_Z; k++)
      zt[k] = zmin + k * (zmax - zmin) / (NUM_Z - 1);

    for (int i = 0; i < NUM_X; i++)
      for (int j = 0; j < NUM_Y; j++)
        for (int k = 0; k < NUM_Z; k++)
          v[0][i*NUM_Y*NUM_Z + j*NUM_Z + k] = x[i*NUM_Y*NUM_Z];

    for (int i = 0; i < NUM_X; i++)
      for (int j = 0; j < NUM_Y; j++)
        for (int k = 0; k < NUM_Z; k++)
          v[1][i*NUM_Y*NUM_Z + j*NUM_Z + k] = y[j*NUM_Z];

    for (int i = 0; i < NUM_X; i++)
      for (int j = 0; j < NUM_Y; j++)
        for (int k = 0; k < NUM_Z; k++)
          v[2][i*NUM_Y*NUM_Z + j*NUM_Z + k] = z[k];

    for (int i = 0; i < NUM_X; i++) {
      xc = xt[i] * xt[i];
      for (int j = 0; j < NUM_Y; j++) {
        yc = yt[j] * yt[j];
        for (int k = 0; k < NUM_Z; k++) {
          zc = zt[k] * zt[k];
          v[3][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc + yc + zc;
        }
      }
    }

    for (int i = 0; i < NUM_X; i++) {
      xc = xt[i] * xt[i];
      for (int j = 0; j < NUM_Y; j++) {
        yc = yt[j];
        for (int k = 0; k < NUM_Z; k++) {
          zc = zt[k] * zt[k] * zt[k];
          v[4][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc + yc + zc;
        }
      }
    }

    for (int i = 0; i < NUM_X; i++) {
      xc = xt[i] * xt[i];
      for (int j = 0; j < NUM_Y; j++) {
        yc = 5 * yt[j];
        for (int k = 0; k < NUM_Z; k++) {
          zc = zt[k] * zt[k];
          v[5][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc + yc + zc;
        }
      }
    }

    for (int i = 0; i < NUM_X; i++) {
      xc = xt[i] * xt[i];
      for (int j = 0; j < NUM_Y; j++) {
        yc = yt[j] * yt[j] * yt[j];
        for (int k = 0; k < NUM_Z; k++) {
          zc = zt[k] * zt[k];
          v[6][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc + yc + zc * zc;
        }
      }
    }

    for (int i = 0; i < NUM_X; i++) {
      xc = xt[i] * xt[i];
      for (int j = 0; j < NUM_Y; j++) {
        yc = yt[j];
        for (int k = 0; k < NUM_Z; k++) {
          zc = zt[k];
          v[7][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc * yc + zc;
        }
      }
    }

    for (int i = 0; i < NUM_X; i++) {
      xc = xt[i] * xt[i];
      for (int j = 0; j < NUM_Y; j++) {
        yc = yt[j] * yt[j];
        for (int k = 0; k < NUM_Z; k++) {
          zc = zt[k];
          v[8][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc * yc + zc * xt[i];
        }
      }
    }

    for (int i = 0; i < NUM_X; i++) {
      xc = xt[i];
      for (int j = 0; j < NUM_Y; j++) {
        yc = yt[j];
        for (int k = 0; k < NUM_Z; k++) {
          zc = zt[k];
          v[9][i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc * yc * zc;
        }
      }
    }
  }
}
