package meshviz.mesh.advanced.PolarGrid2D;

import java.awt.BorderLayout;

import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.nodes.PoPolarGrid2D;

import meshviz.mesh.advanced.meshViewer.MeshViewer;
import util.Example;

public class Main extends Example
{
  private static final float ONE_DEGREE = 0.017453293f;
  private static final int NUM_DATASET = 4;
  private PoPolarGrid2D m_mesh;
  private MeshViewer m_meshViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("PoPolarGrid2D");
  }

  @Override
  public void start() {
    m_mesh = new PoPolarGrid2D();

    compute_geometry_and_val();

    m_meshViewer = new MeshViewer();
    m_meshViewer.setDatasetIndex(1);
    final IViewerExaminer viewer = m_meshViewer.show(m_mesh);

    setLayout(new BorderLayout());
    add(viewer.getComponent());
  }

  @Override
  public void stop()
  {
    m_meshViewer.stop();
  }

  private void compute_geometry_and_val() {
    int nr = 20;
    int nt = 36;
    float[] r = new float [nr];
    float[] t = new float [nt];

    float rmax = 0.5f;
    float rmin = rmax/nr;
    float dr = (rmax-rmin)/(nr-1);
    r[0] = rmin;
    for(int i = 1; i < nr; i++)
      r[i] = r[i-1]+dr;

    float tmax = 280.f * ONE_DEGREE;
    float tmin = 0.f * ONE_DEGREE;
    float dt = (tmax-tmin)/(nt-1);
    t[0] = tmin;
    for(int i = 1; i < nt; i++)
      t[i] = t[i-1]+dt;

    float[][] v = new float[NUM_DATASET][nr*nt];
    // data set 0
    for(int i = 0; i < nr; i++)
      for(int j = 0; j < nt; j++)
        v[0][i*nt+j] = r[i] + (float)Math.cos(t[j]);

    // data set 1
    for(int i = 0; i < nr; i++)
      for(int j = 0; j < nt; j++)
        v[1][i*nt+j] = r[i] + (float)Math.sin(t[j]);

    // data set 2
    for(int i = 0; i < nr; i++)
      for(int j = 0; j < nt; j++)
        v[2][i*nt+j] = (float)Math.exp(-r[i]) *
            (float)Math.sin(t[j])*(float)Math.cos(t[j]);

    // data set 3
    for(int i = 0; i < nr; i++)
      for(int j = 0; j < nt; j++)
        v[3][i*nt+j] = (float)Math.exp(-r[i]) *
            (float)Math.sin(t[j]) + (float)Math.cos(t[j]);

    m_mesh.setGeometry(nr, nt, r, t);
    for (int i = 0; i < NUM_DATASET; i++)
      m_mesh.addValuesSet(i, v[i]);
  }
}
