package meshviz.mesh.advanced.TetrahedronMesh3D;

import java.awt.BorderLayout;
import java.io.File;
import java.net.URL;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.nodes.PoTetrahedronMesh3D;
import com.openinventor.util.AsciiStreamReader;

import meshviz.mesh.advanced.meshViewer.MeshViewer;
import util.Example;

public class Main extends Example
{
  private PoTetrahedronMesh3D m_mesh;
  private float[][] vm;
  private SbVec3f[] vec;
  private MeshViewer m_meshViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("PbTetrahedronMesh3D");
  }

  @Override
  public void start() {
    String oivjhome = SoPreferences.getValue("OIVJHOME");
    File f = new File(oivjhome + "/data/meshviz/poi3u32.txt");
    if (!f.exists()) {
      System.err.println("Data file not found or not installed.");
      System.err.println("You may need to download the optional MeshViz data files.");
      System.exit(1);
    }

    String[] data_names = { "pressure", "k-turbulent", "k-epsilon", "viscosity"};
    m_mesh = new PoTetrahedronMesh3D();

    read_mesh(oivjhome + "/data/meshviz/MESH_TETR.DAT");
    for (int i = 0; i < 4; i++)
      m_mesh.addValuesSet(i, vm[i], data_names[i]);
    m_mesh.addVecsSet(0, vec);

    m_meshViewer = new MeshViewer();
    m_meshViewer.setCourtesyTitle("by courtesy of EDF");
    final IViewerExaminer viewer = m_meshViewer.show(m_mesh);

    setLayout(new BorderLayout());
    add(viewer.getComponent());
  }

  @Override
  public void stop()
  {
    m_meshViewer.stop();
  }

  private void read_mesh(String file_name) {
    int i;
    URL url = MeshViewer.getURL(file_name);
    if (url == null) {
      System.out.println("file " + file_name + " not found");
      System.exit(1);
    }

    AsciiStreamReader meshFile;
    try {
      // Open stream
      System.out.println("Reading file  " + url.getFile());
      meshFile = new AsciiStreamReader(url.openStream());

      // Read number of nodes and tetrahedrons
      int num_nodes = meshFile.readNextInt();
      int num_tetrahedrons = meshFile.readNextInt();

      System.out.println("   num nodes       " + num_nodes);
      System.out.println("   num tetahedrons " + num_tetrahedrons);

      System.out.println("reading nodes coordinates");
      float[] xm = new float[num_nodes];
      float[] ym = new float[num_nodes];
      float[] zm = new float[num_nodes];
      for (i = 0; i < num_nodes; i++) {
        xm[i] = meshFile.readNextFloat();
        ym[i] = meshFile.readNextFloat();
        zm[i] = meshFile.readNextFloat();
      }

      System.out.println("reading nodes vectors");
      vec = new SbVec3f[num_nodes];
      float vx, vy, vz;
      for (i = 0; i < num_nodes; i++) {
        vx = meshFile.readNextFloat();
        vy = meshFile.readNextFloat();
        vz = meshFile.readNextFloat();
        vec[i] = new SbVec3f(vx, vy, vz);
      }

      System.out.println("reading value");
      vm = new float[4][num_nodes];
      for (i = 0; i < num_nodes; i++)
        vm[0][i] = meshFile.readNextFloat();

      for (i = 0; i < num_nodes; i++)
        vm[1][i] = meshFile.readNextFloat();

      for (i = 0; i < num_nodes; i++)
        vm[2][i] = meshFile.readNextFloat();

      for (i = 0; i < num_nodes; i++)
        vm[3][i] = meshFile.readNextFloat();

      for (i = 0; i < num_nodes; i++)
        meshFile.readNextInt();

      System.out.println("reading tetahedrons nodes indices");
      int []tetrahedron_node = new int[num_tetrahedrons * 4];
      for (i = 0; i < num_tetrahedrons*4; i++) {
        tetrahedron_node[i] = meshFile.readNextInt();
      }
      m_mesh.setGeometry(num_nodes, xm, ym, zm, num_tetrahedrons, tetrahedron_node);
      System.out.println("end reading file");
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
}
