package meshviz.mesh.advanced.meshViewer;

import com.openinventor.meshviz.data.*;
import com.openinventor.meshviz.data.PoMesh3DVecGridCrossSection;
import com.openinventor.inventor.nodes.*;
import com.openinventor.inventor.draggers.*;
import com.openinventor.inventor.*;
import com.openinventor.inventor.misc.callbacks.*;

public class Mesh3DVecFieldNode extends Vector3DRepresentNode {
  PoMesh3DVecGridCrossSection m_mesh3DVecField;
  SoSwitch m_mesh3DVecFieldSwitch;
  SoJackDragger m_3DVecFieldDragger;
  SoSwitch m_3DVecFieldDraggerSwitch;

  private SoNode[] m_inventorNodes;
  private String m_name;
  private Mesh3DVecFieldPanel m_panel;
  private Vector3DNode m_parent;
  private SbVec3f m_vecFieldPos;
  private SbVec3f m_planeNormal;
  public float m_scaleFactor;
  public int m_number;
  public PbMesh m_mesh;

  public Mesh3DVecFieldNode(PbMesh mesh, SbBox3f bbox) {
    m_number = m_3DVectFieldsVector.size() + 1;
    m_name = "Vector Field " + m_number;
    m_mesh = mesh;

    // get bbox max size
    SbVec3f bbox_center = bbox.getCenter();
    float[] bbox_size = bbox.getSize().array;
    float max = bbox_size[0];
    if (bbox_size[1] > max)
      max = bbox_size[1];
    if (bbox_size[2] > max)
      max = bbox_size[2];
    float vec_length_factor = 0.05f * max;

    // place vector field
    m_vecFieldPos = new SbVec3f();
    if (m_number == 1)
      m_vecFieldPos = bbox_center;
    else {
      float[] bbox_bounds = bbox.getBounds();
      float vector_field_space = (bbox_bounds[5] - bbox_bounds[2]) / 10.f;
      SbVec3f previous_vec_field_pos
          = ((Mesh3DVecFieldNode)m_3DVectFieldsVector.lastElement()).m_vecFieldPos;
      m_vecFieldPos.setX(bbox_center.getX());
      m_vecFieldPos.setY(bbox_center.getY());
      float vec_field_pos_Z = previous_vec_field_pos.getZ() + vector_field_space;
      if (vec_field_pos_Z > bbox_bounds[5])
        m_vecFieldPos.setZ(bbox_bounds[2] + vector_field_space);
      else
        m_vecFieldPos.setZ(vec_field_pos_Z);
    }
    m_planeNormal = new SbVec3f(0, 0, 1);
    SbPlane vec_field_plane = new SbPlane(m_planeNormal, m_vecFieldPos);

    m_mesh3DVecField = new PoMesh3DVecGridCrossSection();
    m_mesh3DVecField.bodyLengthFactor.setValue(vec_length_factor);
    m_mesh3DVecField.bodyLengthType.setValue(PoMesh3DVec.BodyLengthTypes.CONSTANT_LENGTH);
    m_mesh3DVecField.endArrowHeightFactor.setValue(0.25f);
    m_mesh3DVecField.gridSpacing.setValue(0);
    m_mesh3DVecField.plane.setValue(vec_field_plane);

    // Dragger
    m_scaleFactor = max / 10;

    m_3DVecFieldDragger = new SoJackDragger();
    m_3DVecFieldDragger.scaleFactor.setValue(m_scaleFactor, m_scaleFactor, m_scaleFactor);
    m_3DVecFieldDragger.translation.setValue(m_vecFieldPos);
    m_3DVecFieldDragger.rotation.setValue(new SbVec3f(1, 0, 0),
                                          (float)java.lang.Math.PI/2.f);
    m_3DVecFieldDragger.addValueChangedCallback(new VecFieldDraggerCB(), null);
    {
      m_3DVecFieldDraggerSwitch = new SoSwitch();
      m_3DVecFieldDraggerSwitch.addChild(m_3DVecFieldDragger);
      m_3DVecFieldDraggerSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    }

    {
      SoSeparator mesh3DVecField_sep = new SoSeparator();
      mesh3DVecField_sep.addChild(m_3DVecFieldDraggerSwitch);
      mesh3DVecField_sep.addChild(m_pickSwitch);
      mesh3DVecField_sep.addChild(m_mesh3DVecField);

      m_mesh3DVecFieldSwitch = new SoSwitch();
      m_mesh3DVecFieldSwitch.addChild(mesh3DVecField_sep);
      m_mesh3DVecFieldSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    }

    m_panel = new Mesh3DVecFieldPanel(this);
    m_inventorNodes = new SoNode[]{m_mesh3DVecField};
  }

  public void decreaseNumber() {
    m_number--;
    m_name = "Vector Field " + m_number;
    m_panel.changeTitleName(m_name);
  }

  public String toString() {
    return m_name;
  }

  public RepresentNodePanel getPanel() {
    return m_panel;
  }

  public SoNode[] addToParent(DataNode parent, boolean is_drop_action) {
    m_parent = (Vector3DNode)parent;
    m_parent.addVecField(this);

    if (! is_drop_action) {
      m_3DVectFieldsVector.add(this);
    }

    return m_inventorNodes;
  }

  public SoNode[] delete(boolean is_drop_action) {
    m_parent.removeVecField(this);

    if (! is_drop_action) {
      for (int i = m_number; i < m_3DVectFieldsVector.size(); i++)
        ( (Mesh3DVecFieldNode) m_3DVectFieldsVector.get(i)).decreaseNumber();
      m_3DVectFieldsVector.remove(this);
    }

    return m_inventorNodes;
  }

  public void show(boolean show) {
    if (show)
      m_mesh3DVecFieldSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    else
      m_mesh3DVecFieldSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
  }

  public DataNode getDataNodeParent() {
    return m_parent;
  }

  class VecFieldDraggerCB extends SoDraggerCB {
    public void invoke(SoDragger d) {
      SoJackDragger dragger = ((SoJackDragger)d);
      SbVec3f dragger_pos = dragger.translation.getValue();

      // rotate the plane's normal by the dragger rotation
      SbRotation rotation = dragger.rotation.getValue();
      m_planeNormal = rotation.multVec(new SbVec3f(0, 1, 0));
      m_vecFieldPos = dragger_pos;
      m_mesh3DVecField.plane.setValue(new SbPlane(m_planeNormal, dragger_pos));
    }
  }
}
