package meshviz.mesh.advanced.meshViewer;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

public class Mesh3DVecFieldPanel extends RepresentNodePanel {
  private final String[] STATUS_ITEMS = {
    "None", "Too small", "Too long", "Too small or long"
  };
  private Mesh3DVecFieldNode m_node;
  private JComboBox<String> m_eliminationStatus;
  private SliderPanel m_minLength;
  private SliderPanel m_maxLength;

  public Mesh3DVecFieldPanel(Mesh3DVecFieldNode node) {
    super(node, node.toString());
    m_node = node;

    try {
      File help_file = new File(MeshViewer.m_filePrefix + "data/Mesh3DVecHelp.htm");
      m_helpPage = help_file.toURI().toURL();
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    m_visibilityButton.setToolTipText("Vector field visibility");

    // Grid spacing
    SliderPanel grid_spacing = new SliderPanel(0, 0.1f,
                                               m_node.m_mesh3DVecField.gridSpacing.getValue(),
                                               3);
    grid_spacing.addInfoText("Grid spacing     ");
    grid_spacing.setBoxSelected(false);
    grid_spacing.setMinorTickSpacing(0.1/20);
    grid_spacing.addSliderPanelListener(new SliderPanel.Listener() {
      public void stateChanged(float value) {
        m_node.m_mesh3DVecField.gridSpacing.setValue(value);
      }
    });

    // Vector length
    float body_length_factor = m_node.m_mesh3DVecField.bodyLengthFactor.getValue();
    SliderPanel vector_length = new SliderPanel(0,
                                                body_length_factor/2.f*3.f,
                                                body_length_factor,
                                                5);
    vector_length.addInfoText("Vectors' length");
    vector_length.setTextFieldColumns(5);
    vector_length.addSliderPanelListener(new SliderPanel.Listener() {
      public void stateChanged(float value) {
        m_node.m_mesh3DVecField.bodyLengthFactor.setValue(value);
      }
    });

    // Dragger
    DraggerPanel dragger_panel = new DraggerPanel(m_node.m_3DVecFieldDragger,
                                                  m_node.m_3DVecFieldDraggerSwitch,
                                                  m_node.m_scaleFactor);

    // Elimination panel
    Dimension label_dim = new Dimension(70, 20);
    JLabel status_label = new JLabel("Status");
    status_label.setPreferredSize(new Dimension(label_dim.width+4,
                                                label_dim.height));
    m_eliminationStatus = new JComboBox<String>(STATUS_ITEMS);
    m_eliminationStatus.addActionListener(new EliminationStatusListener());
    float min_length = m_node.m_mesh.getMinVecsSet(0);
    float max_length = m_node.m_mesh.getMaxVecsSet(0);
    m_minLength = new SliderPanel(min_length, max_length/2.f, min_length, 3);
    m_minLength.addInfoText("Min length");
    m_minLength.setInfoTextSize(label_dim);
    m_minLength.setEnabled(false);
    m_minLength.addSliderPanelListener(new SliderPanel.Listener() {
      public void stateChanged(float value) {
        m_node.m_mesh3DVecField.minLength.setValue(value);
      }
    });
    m_maxLength = new SliderPanel(max_length/2.f, max_length, max_length, 3);
    m_maxLength.addInfoText("Max length");
    m_maxLength.setInfoTextSize(label_dim);
    m_maxLength.setEnabled(false);
    m_maxLength.addSliderPanelListener(new SliderPanel.Listener() {
      public void stateChanged(float value) {
        m_node.m_mesh3DVecField.maxLength.setValue(value);
      }
    });


    SpringLayout ep_layout = new SpringLayout();
    JPanel elimination_panel = new JPanel(ep_layout);
    TitledBorder ep_border = new TitledBorder(BorderFactory.createRaisedBevelBorder(),
                                              "Elimination");
    ep_border.setTitleJustification(TitledBorder.LEFT);
    elimination_panel.setBorder(ep_border);
    elimination_panel.add(status_label);
    elimination_panel.add(m_eliminationStatus);
    elimination_panel.add(m_minLength);
    elimination_panel.add(m_maxLength);
    ep_layout.putConstraint(SpringLayout.NORTH, status_label,
                            NORTH_INNER_PANEL_CONSTRAINT+3,
                            SpringLayout.NORTH, elimination_panel);
    ep_layout.putConstraint(SpringLayout.WEST, status_label, 5,
                            SpringLayout.WEST, elimination_panel);
    ep_layout.putConstraint(SpringLayout.NORTH, m_eliminationStatus,
                            NORTH_INNER_PANEL_CONSTRAINT,
                            SpringLayout.NORTH, elimination_panel);
    ep_layout.putConstraint(SpringLayout.WEST, m_eliminationStatus, 5,
                            SpringLayout.EAST, status_label);
    ep_layout.putConstraint(SpringLayout.NORTH, m_minLength,
                            VERT_SPACE_CONSTRAINT,
                            SpringLayout.SOUTH, m_eliminationStatus);
    ep_layout.putConstraint(SpringLayout.NORTH, m_maxLength,
                            VERT_SPACE_CONSTRAINT,
                            SpringLayout.SOUTH, m_minLength);
    ep_layout.putConstraint(SpringLayout.EAST, elimination_panel, 66,
                            SpringLayout.EAST, m_minLength);
    ep_layout.putConstraint(SpringLayout.SOUTH, elimination_panel,
                            SOUTH_CONSTRAINT,
                            SpringLayout.SOUTH, m_maxLength);

    // main panel
    add(grid_spacing);
    add(vector_length);
    add(dragger_panel);
    add(elimination_panel);
    m_spLayout.putConstraint(SpringLayout.NORTH, grid_spacing, NORTH_CONSTRAINT,
                             SpringLayout.NORTH, this);
    m_spLayout.putConstraint(SpringLayout.WEST, grid_spacing, 5,
                             SpringLayout.WEST, this);
    m_spLayout.putConstraint(SpringLayout.NORTH, vector_length, 8,
                             SpringLayout.SOUTH, grid_spacing);
    m_spLayout.putConstraint(SpringLayout.WEST, vector_length, 5,
                             SpringLayout.WEST, this);
    m_spLayout.putConstraint(SpringLayout.NORTH, dragger_panel, 14,
                             SpringLayout.SOUTH, vector_length);
    m_spLayout.putConstraint(SpringLayout.NORTH, elimination_panel,
                             VERT_SPACE_CONSTRAINT,
                             SpringLayout.SOUTH, dragger_panel);
    m_spLayout.putConstraint(SpringLayout.SOUTH, this, SOUTH_CONSTRAINT,
                             SpringLayout.SOUTH, elimination_panel);
  }

  public void changeTitleName(String name) {
    m_name = name;
    m_border.setTitle(m_name);
  }

  class EliminationStatusListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      int selected_index = m_eliminationStatus.getSelectedIndex();
      m_node.m_mesh3DVecField.eliminationStatus.setValue(selected_index);
      switch (selected_index) {
        case 0:
          m_minLength.setEnabled(false);
          m_maxLength.setEnabled(false);
          break;
        case 1:
          m_minLength.setEnabled(true);
          m_maxLength.setEnabled(false);
          break;
        case 2:
          m_minLength.setEnabled(false);
          m_maxLength.setEnabled(true);
          break;
        case 3:
          m_minLength.setEnabled(true);
          m_maxLength.setEnabled(true);
          break;
      }
    }
  }
}
