package meshviz.mesh.advanced.meshViewer;

import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.meshviz.data.PoMesh;
import com.openinventor.meshviz.data.PoMeshFilled;
import com.openinventor.meshviz.graph.PoBase;
import com.openinventor.meshviz.misc.callbacks.PoRebuildCB;

public class MeshFilledNode extends Scalar2DRepresentNode {
  PoMeshFilled m_meshFilled;
  SoSwitch m_meshFilledSwitch;
  int m_whichColoringType;

  private SoNode[] m_inventorNodes;
  private String m_name;
  private MeshFilledPanel m_panel;
  private DataNode m_parent;
  private float m_transparencyValue;

  public MeshFilledNode() {
    m_name = "Mesh Filled";
    m_transparencyValue = 0.f;
    m_whichColoringType = PoMesh.ColoringTypes.COLOR_MAPPING.getValue();

    m_meshFilled = new PoMeshFilled();
    m_meshFilled.addPostRebuildCallback(new TransparencyCB(), null);
    m_meshFilled.zValuesIndex.setValue(m_zDatasetIndex);

    {
      SoSeparator meshFilled_sep = new SoSeparator();
      meshFilled_sep.addChild(m_pickSwitch);
      meshFilled_sep.addChild(m_meshFilled);

      m_meshFilledSwitch = new SoSwitch();
      m_meshFilledSwitch.addChild(meshFilled_sep);
      m_meshFilledSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    }

    m_panel = new MeshFilledPanel(this);
    m_inventorNodes = new SoNode[]{m_meshFilled};
  }

  public void updateZDatasetIndex() {
    m_meshFilled.zValuesIndex.setValue(m_zDatasetIndex);
  }

  public String toString() {
    return m_name;
  }

  public RepresentNodePanel getPanel() {
    return m_panel;
  }

  public SoNode[] addToParent(DataNode parent, boolean is_drop_action) {
    m_parent = parent;
    if (m_parent instanceof Scalar2DNode)
      ((Scalar2DNode)m_parent).addMeshFilled(this);
    else
      ((Mesh2DNode)m_parent).addMeshFilled(this);

    if (! is_drop_action)
      m_poMesh2DNodes.add(this);

    return m_inventorNodes;
  }

  public SoNode[] delete(boolean is_drop_action) {
    if (m_parent instanceof Scalar2DNode)
      ((Scalar2DNode)m_parent).removeMeshFilled(this);
    else
      ((Mesh2DNode)m_parent).removeMeshFilled(this);

    if (! is_drop_action)
      m_poMesh2DNodes.remove(this);

    return m_inventorNodes;
  }

  public void show(boolean show) {
    if (show)
      m_meshFilledSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    else
      m_meshFilledSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
  }

  public void setTransparency(float value) {
    m_transparencyValue = value;
    SoMaterial material =
        (SoMaterial)m_meshFilled.getPart("appearance.material", true);
    for (int i = 0; i < material.diffuseColor.getNum(); i++)
      material.transparency.set1Value(i, value);
  }

  public DataNode getDataNodeParent() {
    return m_parent;
  }

  class TransparencyCB extends PoRebuildCB {
    public void invoke(PoBase base) {
      setTransparency(m_transparencyValue);
    }
  }
}
