package meshviz.mesh.advanced.meshViewer;

import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.meshviz.data.PoMesh;
import com.openinventor.meshviz.data.PoMeshLevelSurf;
import com.openinventor.meshviz.graph.PoBase;
import com.openinventor.meshviz.misc.callbacks.PoRebuildCB;
import com.openinventor.meshviz.nodes.PoIsovaluesList;

public class MeshLevelSurfNode extends Scalar3DRepresentNode {
  PoMeshLevelSurf m_meshLevelSurf;
  SoSwitch m_meshLevelSurfSwitch;
  SoSwitch m_isoValuesSwitch;

  public String[] m_datasetNames;
  public int m_whichColoringType;

  private SoNode[] m_inventorNodes;
  private String m_name;
  private int m_number;
  private int m_parentIndex;
  private MeshLevelSurfPanel m_panel;
  private DataNode m_parent;
  private float m_transparencyValue;

  public MeshLevelSurfNode(SoSwitch iso_values_switch, String[] dataset_names) {
    m_number = m_levelSurfVector.size()+1;
    m_name = "Mesh Level Surface " + m_number;
    m_datasetNames = dataset_names;
    m_transparencyValue = 0.f;
    m_whichColoringType = PoMesh.ColoringTypes.COLOR_MAPPING.getValue();

    m_isoValuesSwitch = (SoSwitch)iso_values_switch.copy();

    m_meshLevelSurf = new PoMeshLevelSurf();
    m_meshLevelSurf.addPostRebuildCallback(new TransparencyCB(), null);

    {
      SoSeparator meshLevelSurf_sep = new SoSeparator();
      meshLevelSurf_sep.addChild(m_pickSwitch);
      meshLevelSurf_sep.addChild(m_meshLevelSurf);

      m_meshLevelSurfSwitch = new SoSwitch();
      m_meshLevelSurfSwitch.addChild(meshLevelSurf_sep);
      m_meshLevelSurfSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    }

    m_panel = new MeshLevelSurfPanel(this);
    m_inventorNodes = new SoNode[]{m_meshLevelSurf};
  }

  public void setDatasetUsed(int which_dataset) {
    m_meshLevelSurf.valuesIndexForLevel.setValue(which_dataset);
    com.openinventor.meshviz.nodes.PoIsovaluesList.IsoList isoList = ((PoIsovaluesList) m_isoValuesSwitch.getChild(which_dataset)).getIsoList(); 
    float min = isoList.min;
    float max = isoList.max;

    float level_value;
    if (m_parentIndex == 0)
      level_value = (min+max)/2.f;
    else
      level_value = (min+max)/2.f + (float)Math.pow(-1, m_parentIndex) *
          (m_parentIndex/2+1) * ((max-min)/10.f);

    m_meshLevelSurf.levelValue.setValue(level_value);
    m_panel.update(which_dataset, min, max, level_value);
  }

  public void decreaseNumber() {
    m_number--;
    m_name = "Mesh Level Surface " + m_number;
    m_panel.changeTitleName(m_name);
  }

  public String toString() {
    return m_name;
  }

  public RepresentNodePanel getPanel() {
    return m_panel;
  }

  public SoNode[] addToParent(DataNode parent, boolean is_drop_action) {
    m_parent = parent;
    int which_dataset;

    if (m_parent instanceof Scalar3DNode) {
      Scalar3DNode scalar_parent =  (Scalar3DNode) m_parent;
      which_dataset = scalar_parent.getWhichDataset();
      m_parentIndex = scalar_parent.m_levelSurfIndex;
      scalar_parent.addMeshLevelSurf(this);
    } else {
      which_dataset = 0;
      Mesh3DNode mesh_parent = (Mesh3DNode)parent;
      m_parentIndex = mesh_parent.m_levelSurfIndex;
      mesh_parent.addMeshLevelSurf(this);
    }

    if (! is_drop_action) {
      setDatasetUsed(which_dataset);
      m_levelSurfVector.add(this);
   }

   return m_inventorNodes;
  }

  public SoNode[] delete(boolean is_drop_action) {
    if (parent instanceof Mesh3DNode)
      ((Mesh3DNode)m_parent).removeMeshLevelSurf(this);
    else
      ((Scalar3DNode)m_parent).removeMeshLevelSurf(this);

    if (! is_drop_action) {
      for (int i = m_number; i < m_levelSurfVector.size(); i++)
        ( (MeshLevelSurfNode) m_levelSurfVector.get(i)).decreaseNumber();
      m_levelSurfVector.remove(m_number - 1);
    }

    return m_inventorNodes;
  }

  public void show(boolean show) {
    if (show)
      m_meshLevelSurfSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    else
      m_meshLevelSurfSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
  }

  public void setTransparency(float value) {
    m_transparencyValue = value;
    SoMaterial material =
        (SoMaterial)m_meshLevelSurf.getPart("appearance.material");

    for (int i = 0; i < material.diffuseColor.getNum(); i++)
      material.transparency.set1Value(i, value);
  }

  public DataNode getDataNodeParent() {
    return m_parent;
  }

  class TransparencyCB extends PoRebuildCB {
    public void invoke(PoBase base) {
      setTransparency(m_transparencyValue);
    }
  }
}
