package meshviz.mesh.advanced.meshViewer;

import com.openinventor.inventor.nodes.*;
import com.openinventor.meshviz.data.*;

public class MeshLimitNode extends Scalar2DRepresentNode {
  PoMeshLimit m_meshLimit;
  SoSwitch m_meshLimitSwitch;

  private SoNode[] m_inventorNodes;
  private String m_name;
  private MeshLimitPanel m_panel;
  private Mesh2DNode m_parent;

  public MeshLimitNode() {
    m_name = "Mesh Limit";

    m_meshLimit = new PoMeshLimit();
    m_meshLimit.zValuesIndex.setValue(m_zDatasetIndex);

    {
      SoSeparator meshLimit_sep = new SoSeparator();
      meshLimit_sep.addChild(m_pickSwitch);
      meshLimit_sep.addChild(m_meshLimit);

      m_meshLimitSwitch = new SoSwitch();
      m_meshLimitSwitch.addChild(meshLimit_sep);
      m_meshLimitSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    }

    m_panel = new MeshLimitPanel(this);
    m_inventorNodes = new SoNode[]{m_meshLimit};
  }

  public void updateZDatasetIndex() {
    m_meshLimit.zValuesIndex.setValue(m_zDatasetIndex);
  }

  public String toString() {
    return m_name;
  }

  public RepresentNodePanel getPanel() {
    return m_panel;
  }

  public SoNode[] addToParent(DataNode parent, boolean is_drop_action) {
    m_parent = (Mesh2DNode)parent;
    m_parent.addMeshLimit(this);

    if (! is_drop_action)
      m_poMesh2DNodes.add(this);

    return m_inventorNodes;
  }

  public SoNode[] delete(boolean is_drop_action) {
    m_parent.removeMeshLimit(this);

    if (! is_drop_action)
      m_poMesh2DNodes.remove(this);

    return m_inventorNodes;
  }

  public void show(boolean show) {
    if (show)
      m_meshLimitSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    else
      m_meshLimitSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
  }

  public DataNode getDataNodeParent() {
    return m_parent;
  }
}
