package meshviz.mesh.advanced.meshViewer;

import com.openinventor.meshviz.data.*;
import com.openinventor.inventor.nodes.*;

public class MeshLinesNode extends Scalar2DRepresentNode {
  PoMeshLines m_meshLines;
  SoSwitch m_meshLinesSwitch;

  private SoNode[] m_inventorNodes;
  private String m_name;
  private MeshLinesPanel m_panel;
  private DataNode m_parent;

  public MeshLinesNode() {
    m_name = "Mesh Lines";

    m_meshLines = new PoMeshLines();
    m_meshLines.valuesIndex.setValue( -1);
    m_meshLines.zValuesIndex.setValue(m_zDatasetIndex);

    {
      SoSeparator meshLines_sep = new SoSeparator();
      meshLines_sep.addChild(m_pickSwitch);
      meshLines_sep.addChild(m_meshLines);

      m_meshLinesSwitch = new SoSwitch();
      m_meshLinesSwitch.addChild(meshLines_sep);
      m_meshLinesSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    }

    m_panel = new MeshLinesPanel(this);
    m_inventorNodes = new SoNode[]{m_meshLines};
  }

  public void updateZDatasetIndex() {
    m_meshLines.zValuesIndex.setValue(m_zDatasetIndex);
  }

  public String toString() {
    return m_name;
  }

  public RepresentNodePanel getPanel() {
    return m_panel;
  }

  public SoNode[] addToParent(DataNode parent, boolean is_drop_action) {
    m_parent = parent;
    if (m_parent instanceof Scalar2DNode)
      ((Scalar2DNode)m_parent).addMeshLines(this);
    else
      ((Mesh2DNode)m_parent).addMeshLines(this);

    if (! is_drop_action)
      m_poMesh2DNodes.add(this);

    return m_inventorNodes;
  }

  public SoNode[] delete(boolean is_drop_action) {
    if (m_parent instanceof Scalar2DNode)
      ((Scalar2DNode)m_parent).removeMeshLines(this);
    else
      ((Mesh2DNode)m_parent).removeMeshLines(this);

    if (!is_drop_action)
      m_poMesh2DNodes.remove(this);

    return m_inventorNodes;
  }

  public void show(boolean show) {
    if (show)
      m_meshLinesSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    else
      m_meshLinesSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
  }

  public DataNode getDataNodeParent() {
    return m_parent;
  }
}
