package meshviz.mesh.advanced.meshViewer;

import com.openinventor.meshviz.data.*;
import com.openinventor.inventor.nodes.*;

public class MeshSkeletonNode extends Scalar3DRepresentNode {
  PoMeshSkeleton m_meshSkeleton;
  SoSwitch m_meshSkeletonSwitch;
  SoSeparator m_meshSkeletonSep;

  private SoNode[] m_inventorNodes;
  private String m_name;
  private MeshSkeletonPanel m_panel;
  private DataNode m_parent;

  public MeshSkeletonNode() {
    m_name = "Mesh Skeleton";
    m_panel = new MeshSkeletonPanel(this);

    m_meshSkeleton = new PoMeshSkeleton();
    m_meshSkeleton.set("appearance.material", "diffuseColor 0.5 0.25 0.25");

    {
      m_meshSkeletonSwitch = new SoSwitch();
      m_meshSkeletonSwitch.addChild(m_pickSwitch);
      m_meshSkeletonSwitch.addChild(m_meshSkeleton);
      m_meshSkeletonSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);

      m_meshSkeletonSep = new SoSeparator();
      m_meshSkeletonSep.addChild(m_meshSkeletonSwitch);
    }

    m_inventorNodes = new SoNode[]{m_meshSkeleton};
  }

  public String toString() {
    return m_name;
  }

  public RepresentNodePanel getPanel() {
    return m_panel;
  }

  public SoNode[] addToParent(DataNode parent, boolean is_drop_action) {
    m_parent = parent;
    if (m_parent instanceof Mesh3DNode)
      ((Mesh3DNode)m_parent).addMeshSkeleton(this);
    else
      ((Scalar3DNode)m_parent).addMeshSkeleton(this);

    return m_inventorNodes;
  }

  public SoNode[] delete(boolean is_drop_action) {
    if (m_parent instanceof Mesh3DNode)
      ((Mesh3DNode)m_parent).removeMeshSkeleton(this);
    else
      ((Scalar3DNode)m_parent).removeMeshSkeleton(this);

    return m_inventorNodes;
  }

  public void show(boolean show) {
    if (show)
      m_meshSkeletonSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    else
      m_meshSkeletonSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
  }

  public DataNode getDataNodeParent() {
    return m_parent;
  }
}
