package meshviz.mesh.advanced.meshViewer;

import com.openinventor.inventor.nodes.*;

class Scalar3DNode extends ScalarNode {
  private MeshViewer m_meshViewer;
  public int m_levelSurfIndex;

  public Scalar3DNode(MeshViewer mesh_viewer, String name, int which_dataset) {
    m_name = name;
    m_whichDataset = which_dataset;
    m_meshViewer = mesh_viewer;
    m_levelSurfIndex = 0;

    m_dataGroup = (SoGroup)mesh_viewer.m_dataSwitch.getChild(which_dataset).copy();

    m_scalarSep = new SoSeparator();
    m_scalarSep.addChild(m_dataGroup);

    m_meshViewer.m_scene3D.addChild(m_scalarSep);
  }

  // Cut plane
  public void addCutPlane(MeshCutPlaneNode cp_node) {
    cp_node.m_meshCrossSection.coloringType.setValue(cp_node.m_whichColoringType);
    cp_node.m_meshCrossContour.coloringType.setValue(cp_node.m_whichColoringType);
    cp_node.m_meshCrossSection.valuesIndex.setValue(m_whichDataset);
    cp_node.m_meshCrossContour.valuesIndex.setValue(m_whichDataset);

    m_scalarSep.insertChild(cp_node.m_meshCutPlaneSwitch, 1);
  }

  public void removeCutPlane(MeshCutPlaneNode cp_node) {
    m_scalarSep.removeChild(cp_node.m_meshCutPlaneSwitch);
  }

  // Mesh skin
  public void addMeshSkin(MeshSkinNode ms_node) {
    ms_node.m_meshSkin.coloringType.setValue(ms_node.m_whichColoringType);
    ms_node.m_meshSkin.valuesIndex.setValue(m_whichDataset);
    m_scalarSep.addChild(ms_node.m_meshSkinSep);
  }

  public void removeMeshSkin(MeshSkinNode ms_node) {
    m_scalarSep.removeChild(ms_node.m_meshSkinSep);
  }

  // Mesh level surface
  public void addMeshLevelSurf(MeshLevelSurfNode mls_node) {
    mls_node.m_meshLevelSurf.coloringType.setValue(mls_node.m_whichColoringType);
    mls_node.m_meshLevelSurf.valuesIndex.setValue(m_whichDataset);
    m_scalarSep.addChild(mls_node.m_meshLevelSurfSwitch);
    m_levelSurfIndex++;
  }

  public void removeMeshLevelSurf(MeshLevelSurfNode mls_node) {
    m_scalarSep.removeChild(mls_node.m_meshLevelSurfSwitch);
    m_levelSurfIndex--;
  }

  // Mesh skeleton
  public void addMeshSkeleton(MeshSkeletonNode msk_node) {
    m_scalarSep.addChild(msk_node.m_meshSkeletonSep);
  }

  public void removeMeshSkeleton(MeshSkeletonNode ms_node) {
    m_scalarSep.removeChild(ms_node.m_meshSkeletonSep);
  }
}
