package meshviz.mesh.sample.hexahedronMesh3DVec;

import java.awt.BorderLayout;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.meshviz.nodes.PoHexahedronMesh3D;

import meshviz.mesh.sample.Vec3DViewer;
import util.Example;
/**
  * Draws a vector field on a 3D indexed mesh (made up of hexahedrons).
  * Controls the aspect of the arrows representing the vector field.
  * The mesh skin is also drawn and can be transparent.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private Vec3DViewer viewer;

  @Override
  public void start() {
    int numNodes = 16, numCells = 3 ;
    float[] x = { 0,1,2, 0,1,2, 1,2.5F, 0,1,2, 0,1,2, 1,2.5F };
    float[] y = { 0,0,-1, 1,1,1, 2,2.5F, 0,0,-1, 1,1,1, 2,2.5F};
    float[] z = { 0,0,0,0,0,0,0,0, 1,1,1,1,1,1,1,1};
    int[] cellIndex = {0,1,4,3,8,9,12,11, 1,2,5,4,9,10,13,12, 4,5,7,6,12,13,15,14};

    SbVec3f[] vec = new SbVec3f[numNodes] ;
    float[] val = {0,1,1,2,5,2,3,1, 1,1,2,2,5,4,3,1};
    vec[0] = new SbVec3f(0.1F,0.2F,0.3F);
    vec[1] = new SbVec3f(0.3F,-0.1F,0.2F);
    vec[2] = new SbVec3f(0, 0.2F, -0.5F);
    vec[3] = new SbVec3f(-0.3F, 0.1F, 0.2F);
    vec[4] = new SbVec3f(-0.3F, -0.1F, 0.3F);
    vec[5] = new SbVec3f(0.1F,0.2F,0.3F);
    vec[6] = new SbVec3f(0.3F,-0.1F,0.2F);
    vec[7] = new SbVec3f(0, 0.2F, -0.5F);
    vec[8] = new SbVec3f(-0.3F, 0.1F, 0.2F);
    vec[9] = new SbVec3f(-0.3F, -0.1F, 0.6F);
    vec[10] = new SbVec3f(0.3F, 0.1F, 0.3F);
    vec[11] = new SbVec3f(-0.3F, -0.1F, 1.3F);
    vec[12] = new SbVec3f(0.3F, -0.1F, 0.3F);
    vec[13] = new SbVec3f(-0.3F, -1.1F, 0.3F);
    vec[14] = new SbVec3f(0.3F, 0.1F, 0.3F);
    vec[15] = new SbVec3f(-0.3F, -0.1F, -.3F);

    PoHexahedronMesh3D mesh = new PoHexahedronMesh3D();
    mesh.setGeometry(numNodes, x, y, z, numCells,cellIndex);
    mesh.addValuesSet(0,val);
    mesh.addVecsSet(0,vec);

    viewer = new Vec3DViewer();
    viewer.setFileName("PoHexahedronMesh3D.iv") ;
    viewer.show(mesh) ;
    viewer.getViewer().viewAll();

    setLayout(new BorderLayout());
    viewer.getViewer().getComponent().setPreferredSize(new java.awt.Dimension(600, 500));
    add(viewer);
  }

  @Override
  public void stop()
  {
    viewer.getViewer().dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("PoHexahedronMeh3D");
 }
}
