package meshviz.mesh.sample.indexedMesh2DVec;

import java.awt.BorderLayout;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.meshviz.nodes.PoIndexedMesh2D;

import meshviz.mesh.sample.Vec2DViewer;
import util.Example;
/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private Vec2DViewer viewer;

  @Override
  public void start() {
    int numNodes = 6, numCells = 3 ;
    float[] x = {0,1,-1,5,6,4} ;
    float[] y = {1,-0.5F,-1,1,0,0} ;
    int[] cellIndex = {0,1,2, 1,0,3,5, 3,4,5} ;
    int[] cellType = {3,4,3} ;

    float[] val = {0,1,1,2,4,5} ;
    float[] alt = {0,0,1,0,0,0} ;
    SbVec3f[] vec = new SbVec3f[numNodes] ;
    vec[0] = new SbVec3f(0.1F,0.2F,0F);
    vec[1] = new SbVec3f(0.3F,-0.1F,0F) ;
    vec[2] = new SbVec3f(0,0.2F,0F) ;
    vec[3] = new SbVec3f(-0.3F,0.1F,0F) ;
    vec[4] = new SbVec3f(-0.3F,-0.1F,0F) ;
    vec[5] = new SbVec3f(-0.3F,0.1F,0F) ;

    PoIndexedMesh2D mesh = new PoIndexedMesh2D();
    mesh.setGeometry(numNodes, x, y, numCells, cellIndex, cellType);

    mesh.addValuesSet(0,val);
    mesh.addValuesSet(1,alt);
    mesh.addVecsSet(0,vec);

    viewer = new Vec2DViewer();
    viewer.setFileName("PoIndexedMesh2D.iv") ;
    viewer.show(mesh) ;
    viewer.getViewer().viewAll();

    setLayout(new BorderLayout());
    viewer.getViewer().getComponent().setPreferredSize(new java.awt.Dimension(600, 500));
    add(viewer);
  }

  @Override
  public void stop()
  {
    viewer.getViewer().dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("PoIndexedMesh2D");
  }
}
