package meshviz.mesh.sample.indexedMesh3DVec;

import java.awt.BorderLayout;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.meshviz.nodes.PoIndexedMesh3D;

import meshviz.mesh.sample.Vec3DViewer;
import util.Example;
/**
  * Draws a vector field on a 3D indexed mesh (made up of tetrahedrons
  * and pentahedron). Controls the aspect of the arrows representing
  * the vector field. The mesh skin is also drawn and can be transparent.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private Vec3DViewer viewer;

  @Override
  public void start() {
    int numNodes = 8, numCells = 3 ;
    float[] x = {  0,1,-1,0, 5,6,4,5 };
    float[] y = {  0,0,0,2, 0,0,0,2 };
    float[] z = {  1,-1,0,0, 1,0,-1,0 };
    int[] cellIndex = {0,2,1,3, 4,6,5,7, 0,3,1,4,7,6};
    int[] cellType = {4,4,6};

    SbVec3f[] vec = new SbVec3f[numNodes] ;
    float[] val = {0,1,1,2,4,5,3,0};

    vec[0] = new SbVec3f(0.1F,0.2F,0.3F);
    vec[1] = new SbVec3f(0.3F,-0.1F,0.2F);
    vec[2] = new SbVec3f(0, 0.2F, -0.5F);
    vec[3] = new SbVec3f(-0.3F, 0.1F, 0.2F);
    vec[4] = new SbVec3f(-0.3F, -0.1F, 0.3F);
    vec[5] = new SbVec3f(-0.3F, 0.1F, -0.3F);
    vec[6] = new SbVec3f(0.6F, 0.1F, 0.2F);
    vec[7] = new SbVec3f(-0.5F, 0.5F, -0.9F);

    PoIndexedMesh3D mesh = new PoIndexedMesh3D();
    mesh.setGeometry(numNodes, x, y, z, numCells, cellIndex, cellType);
    mesh.addValuesSet(0,val);
    mesh.addVecsSet(0,vec);

    viewer = new Vec3DViewer();
    viewer.setFileName("PoIndexedMesh3D.iv") ;
    viewer.show(mesh) ;
    viewer.getViewer().viewAll();

    setLayout(new BorderLayout());
    viewer.getViewer().getComponent().setPreferredSize(new java.awt.Dimension(600, 500));
    add(viewer);
  }

  @Override
  public void stop()
  {
    viewer.getViewer().dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("PoIndexedMesh3D");
  }
}
