package meshviz.mesh.sample.paralCartesianGrid3DVec;

import java.awt.BorderLayout;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.meshviz.nodes.PoParalCartesianGrid3D;

import meshviz.mesh.sample.Vec3DViewer;
import util.Example;

/**
  * Draws a vector field on a 3D parallel grid mesh. Controls
  * the aspect of the arrows representing the vector field.
  * The mesh skin is also drawn and can be transparent.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private Vec3DViewer viewer;

  @Override
  public void start() {
    int numX = 3, numY = 3, numZ = 3 ;
    float[] x = {0.0F,0.5F,1.0F} ;
    float[] y = {0.0F,0.5F,1.0F} ;
    float[] z = {0.0F,0.5F,1.0F} ;

    SbVec3f[] vec = new SbVec3f[numX*numY*numZ] ;
    float[] val = new float[numX*numY*numZ];

    PoParalCartesianGrid3D mesh = new PoParalCartesianGrid3D();
    mesh.setGeometry(numX, numY, numZ, x, y, z);

    for(int i=0 ; i<numX ; i++)
      for(int j=0 ; j<numY ; j++)
	for(int k=0 ; k<numZ ; k++) {
	  int ijk = k + numY * ( i*numX + j);
	  val[ijk] = i * (numY - j) * k ;
	  vec[ijk] = new SbVec3f(0.0125F*(j+1)*(numZ-k), 0.0125F*(i+1)*(k+1), 0.1F*(i+1));
	}

    mesh.addValuesSet(0,val);
    mesh.addVecsSet(0,vec);

    viewer = new Vec3DViewer();
    viewer.setFileName("PoParalCartesianGrid3D.iv") ;
    viewer.show(mesh) ;
    viewer.getViewer().viewAll();

    viewer.getViewer().getComponent().setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(viewer);
  }

  @Override
  public void stop()
  {
    viewer.getViewer().dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("PoParalCartesianGrid3D");
  }
}
