package meshvizxlm.eclipsemeshviz.gui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.Timer;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

@SuppressWarnings("serial")
public class AnimationPanel extends JPanel
{
  private static final int SLIDER_MIN = 1;
  private static final int SLIDER_MAX = 100;

  private Timer m_animationTimer;
  private SliderPanel m_animSliderPanel;
  private JButton m_playButton;

  private ArrayList<AnimationListener> m_listeners = new ArrayList<AnimationListener>();

  public AnimationPanel()
  {
    m_animationTimer = new Timer(50, new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        int pos = (int) m_animSliderPanel.getSliderValue();
        if ( pos == SLIDER_MAX )
          pos = SLIDER_MIN;
        else
          pos++;
        m_animSliderPanel.setSliderValue(pos);
      }
    });

    buildUI();
    addListeners();
  }

  public void addListener(AnimationListener listener)
  {
    m_listeners.add(listener);
  }

  private void addListeners()
  {
    m_playButton.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        if ( m_animationTimer.isRunning() )
        {
          m_animationTimer.stop();
          m_playButton.setText("Play");
        }
        else
        {
          m_animationTimer.start();
          m_playButton.setText("Stop");
        }
      }
    });

    m_animSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        for ( AnimationListener listener : m_listeners )
          listener.setPlaybackPosition((int) m_animSliderPanel.getRelativeSliderValue());
      }
    });
  }

  private void buildUI()
  {
    setLayout(new BorderLayout());

    JPanel animationPanel = new JPanel();
    add(animationPanel, BorderLayout.NORTH);

    FlowLayout flowLayout = (FlowLayout) animationPanel.getLayout();
    flowLayout.setAlignment(FlowLayout.LEFT);

    m_playButton = new JButton("Play");
    m_playButton.setSelected(false);
    animationPanel.add(m_playButton);

    m_animSliderPanel = new SliderPanel(SLIDER_MIN, SLIDER_MAX, SLIDER_MIN);
    flowLayout = (FlowLayout) m_animSliderPanel.getLayout();
    flowLayout.setAlignment(FlowLayout.LEFT);
    m_animSliderPanel.setBoxSelected(true);
    animationPanel.add(m_animSliderPanel);
  }

  @Override
  public String toString()
  {
    return "Animation";
  }

  public void setAnimationSliderPosition(int frame)
  {
    m_animSliderPanel.setSliderValue(frame);
  }

  public interface AnimationListener
  {
    public void setPlaybackPosition(int value);
  }
}
