package meshvizxlm.eclipsemeshviz.gui;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

import meshvizxlm.eclipsemeshviz.DemoSettings;

@SuppressWarnings("serial")
public class DownsamplingPanel extends JPanel implements DownsamplingParamListener
{

  private JButton m_fullResolutionButton;
  private JCheckBox m_chckbxDownsampling;
  private SliderPanel m_resolutionSliderPanel;
  private ArrayList<DownsamplingListener> m_listeners;
  private SliderPanel m_fullResolutionDelayPanel;
  private boolean m_notifyListeners;

  public DownsamplingPanel()
  {
    m_notifyListeners = true;
    m_listeners = new ArrayList<DownsamplingListener>();

    buildUI();
    addListeners();

    if ( DemoSettings.ASYNC_PROCESSING )
    {
      // Disable Downsampling
      m_chckbxDownsampling.doClick();
      m_chckbxDownsampling.setEnabled(false);
      m_resolutionSliderPanel.setSliderValue(100);
      m_resolutionSliderPanel.setEnabled(false);
      m_fullResolutionButton.setEnabled(false);
    }
  }

  private void buildUI()
  {
    BoxLayout boxLayout = new BoxLayout(this, BoxLayout.Y_AXIS);
    setLayout(boxLayout);

    JPanel panel1 = new JPanel();
    add(panel1);

    FlowLayout flowLayout = (FlowLayout) panel1.getLayout();
    flowLayout.setAlignment(FlowLayout.LEFT);

    m_chckbxDownsampling = new JCheckBox("Auto Downsampling");
    m_chckbxDownsampling.setSelected(true);
    panel1.add(m_chckbxDownsampling);

    m_resolutionSliderPanel = new SliderPanel(1, 100, 50);
    m_resolutionSliderPanel.setEnabled(false);
    m_resolutionSliderPanel.addInfoText("Resolution (%)");
    flowLayout = (FlowLayout) m_resolutionSliderPanel.getLayout();
    flowLayout.setAlignment(FlowLayout.LEFT);
    panel1.add(m_resolutionSliderPanel);

    JPanel panel2 = new JPanel();
    add(panel2);
    flowLayout = (FlowLayout) panel2.getLayout();
    flowLayout.setAlignment(FlowLayout.LEFT);

    m_fullResolutionButton = new JButton("Full Resolution");
    panel2.add(m_fullResolutionButton);

    m_fullResolutionDelayPanel = new SliderPanel(1, 10, 5);
    m_fullResolutionDelayPanel.addInfoText("Delay to full resolution(s)");
    flowLayout = (FlowLayout) m_resolutionSliderPanel.getLayout();
    flowLayout.setAlignment(FlowLayout.LEFT);
    panel2.add(m_fullResolutionDelayPanel);
  }

  private void addListeners()
  {
    m_chckbxDownsampling.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        boolean enabled = e.getStateChange() == ItemEvent.SELECTED;
        m_resolutionSliderPanel.setEnabled(!enabled);
        m_fullResolutionDelayPanel.setEnabled(enabled);
        for ( DownsamplingListener listener : m_listeners )
          listener.autoDownsamplingStateChanged(enabled, m_resolutionSliderPanel.getSliderValue() / 100.);
      }
    });

    m_resolutionSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        if ( m_notifyListeners )
        {
          for ( DownsamplingListener listener : m_listeners )
          {
            listener.downsamplingParamChanged(m_resolutionSliderPanel.getSliderValue() / 100.);
          }
        }
      }
    });

    m_fullResolutionButton.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent arg0)
      {
        if ( m_notifyListeners )
          for ( DownsamplingListener listener : m_listeners )
            listener.fullResolutionRequest();
      }
    });

    m_fullResolutionDelayPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        if ( m_notifyListeners )
          for ( DownsamplingListener listener : m_listeners )
            listener.delayToFullResolutionChanged((int) m_fullResolutionDelayPanel.getSliderValue());
      }
    });
  }

  public void addListener(DownsamplingListener listener)
  {
    m_listeners.add(listener);
  }

  @Override
  public void delayToFullResolutionChanged(int value)
  {
    m_notifyListeners = false;
    m_fullResolutionDelayPanel.setSliderValue(value);
    m_notifyListeners = true;
  }

  @Override
  public void autoDownsamplingStateChanged(boolean activate, double resolution)
  {
    m_notifyListeners = false;
    m_chckbxDownsampling.setSelected(activate);
    m_notifyListeners = true;
  }

  @Override
  public void downsamplingParamChanged(double resolution)
  {
    m_notifyListeners = false;
    m_notifyListeners = true;
  }
}
