package meshvizxlm.eclipsemeshviz.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.actions.SoGLRenderAction.TransparencyTypes;
import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;
import com.openinventor.meshvizxlm.mapping.nodes.MoPredefinedColorMapping.PredefColorMapping;

public class DrawStylePanel extends JPanel implements ActionListener
{

  private SliderPanel m_antiAliasingSliderPanel;
  private SliderPanel m_fadingSliderPanel;
  private JLabel m_transparencyTypeLabel;
  private JComboBox<String> m_comboBoxTransparencyType;
  private JComboBox<String> m_comboBoxColormaps;
  private ArrayList<RenderingOptionListener> m_renderingOptionListeners;
  private Map<String, SoGLRenderAction.TransparencyTypes> transparencyTypesMap;
  private JCheckBox m_facesButton;
  private JCheckBox m_edgesButton;
  private JCheckBox m_pointsButton;

  public DrawStylePanel()
  {
    initiateMap();
    m_renderingOptionListeners = new ArrayList<RenderingOptionListener>();
    buildUI();
    addListeners();
  }

  @Override
  public String toString()
  {
    return "Draw Style";
  }

  private void buildUI()
  {
    GridBagLayout gridBagLayout = new GridBagLayout();
    gridBagLayout.columnWidths = new int[] { 61, 0, 0, 0 };
    gridBagLayout.rowHeights = new int[] { 0, 0, 18, 18, 18, 0, 18, 18, 0 };
    gridBagLayout.columnWeights = new double[] { 0.0, 0.0, 0.0, Double.MIN_VALUE };
    gridBagLayout.rowWeights = new double[] { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE };
    setLayout(gridBagLayout);

    m_antiAliasingSliderPanel = new SliderPanel(0, 1, 0, 3);
    m_antiAliasingSliderPanel.addInfoText("Anti-aliasing");
    GridBagConstraints gbc_m_antiAliasingSliderPanel = new GridBagConstraints();
    gbc_m_antiAliasingSliderPanel.gridwidth = 3;
    gbc_m_antiAliasingSliderPanel.insets = new Insets(20, 0, 5, 5);
    gbc_m_antiAliasingSliderPanel.anchor = GridBagConstraints.WEST;
    gbc_m_antiAliasingSliderPanel.gridx = 0;
    gbc_m_antiAliasingSliderPanel.gridy = 2;
    m_antiAliasingSliderPanel.setBoxSelected(false);
    add(m_antiAliasingSliderPanel, gbc_m_antiAliasingSliderPanel);

    m_facesButton = new JCheckBox("Faces");
    m_facesButton.setSelected(true);
    GridBagConstraints gbc_m_displayFaces = new GridBagConstraints();
    gbc_m_displayFaces.insets = new Insets(0, 0, 5, 5);
    gbc_m_displayFaces.gridx = 0;
    gbc_m_displayFaces.gridy = 0;
    add(m_facesButton, gbc_m_displayFaces);

    m_edgesButton = new JCheckBox("Edges");
    m_edgesButton.setSelected(true);
    GridBagConstraints gbc_m_displayEdges = new GridBagConstraints();
    gbc_m_displayEdges.insets = new Insets(0, 0, 5, 5);
    gbc_m_displayEdges.gridx = 1;
    gbc_m_displayEdges.gridy = 0;
    add(m_edgesButton, gbc_m_displayEdges);

    m_pointsButton = new JCheckBox("Points");
    GridBagConstraints gbc_m_displayPoints = new GridBagConstraints();
    gbc_m_displayPoints.anchor = GridBagConstraints.WEST;
    gbc_m_displayPoints.insets = new Insets(0, 0, 5, 0);
    gbc_m_displayPoints.gridx = 2;
    gbc_m_displayPoints.gridy = 0;
    add(m_pointsButton, gbc_m_displayPoints);

    m_fadingSliderPanel = new SliderPanel(0, 10, 5, 3);
    m_fadingSliderPanel.addInfoText("Fading Threshold");
    GridBagConstraints gbc_fadingSliderPanel = new GridBagConstraints();
    gbc_fadingSliderPanel.gridwidth = 3;
    gbc_fadingSliderPanel.insets = new Insets(0, 0, 5, 5);
    gbc_fadingSliderPanel.anchor = GridBagConstraints.WEST;
    gbc_fadingSliderPanel.gridx = 0;
    gbc_fadingSliderPanel.gridy = 1;
    m_fadingSliderPanel.setBoxSelected(false);
    add(m_fadingSliderPanel, gbc_fadingSliderPanel);

    m_transparencyTypeLabel = new JLabel("Transparency Type :");
    GridBagConstraints gbc_labelTransparencyType = new GridBagConstraints();
    gbc_labelTransparencyType.gridwidth = 3;
    gbc_labelTransparencyType.fill = GridBagConstraints.HORIZONTAL;
    gbc_labelTransparencyType.insets = new Insets(5, 5, 5, 5);
    gbc_labelTransparencyType.gridx = 0;
    gbc_labelTransparencyType.gridy = 3;
    add(m_transparencyTypeLabel, gbc_labelTransparencyType);

    String[] transparencyTypes = transparencyTypesMap.keySet().toArray(new String[transparencyTypesMap.size()]);
    m_comboBoxTransparencyType = new JComboBox<>(transparencyTypes);
    m_comboBoxTransparencyType.setSelectedIndex(1);
    GridBagConstraints gbc_comboBoxTransparencyType = new GridBagConstraints();
    gbc_comboBoxTransparencyType.gridwidth = 3;
    gbc_comboBoxTransparencyType.fill = GridBagConstraints.HORIZONTAL;
    gbc_comboBoxTransparencyType.insets = new Insets(5, 5, 5, 5);
    gbc_comboBoxTransparencyType.gridx = 0;
    gbc_comboBoxTransparencyType.gridy = 4;
    add(m_comboBoxTransparencyType, gbc_comboBoxTransparencyType);

    JLabel colormapsLabel = new JLabel("Color maps :");
    GridBagConstraints gbc_labelColormaps = new GridBagConstraints();
    gbc_labelColormaps.gridwidth = 3;
    gbc_labelColormaps.fill = GridBagConstraints.HORIZONTAL;
    gbc_labelColormaps.insets = new Insets(5, 5, 5, 5);
    gbc_labelColormaps.gridx = 0;
    gbc_labelColormaps.gridy = 5;
    add(colormapsLabel, gbc_labelColormaps);

    m_comboBoxColormaps = new JComboBox<>();
    for ( PredefColorMapping pcm : PredefColorMapping.values() )
      m_comboBoxColormaps.addItem(pcm.name());
    m_comboBoxColormaps.setSelectedItem(PredefColorMapping.RAINBOW_TURBO.name());
    GridBagConstraints gbc_comboBoxColormaps = new GridBagConstraints();
    gbc_comboBoxColormaps.gridwidth = 3;
    gbc_comboBoxColormaps.fill = GridBagConstraints.HORIZONTAL;
    gbc_comboBoxColormaps.insets = new Insets(5, 5, 5, 5);
    gbc_comboBoxColormaps.gridx = 0;
    gbc_comboBoxColormaps.gridy = 6;
    add(m_comboBoxColormaps, gbc_comboBoxColormaps);
  }

  private void addListeners()
  {
    m_antiAliasingSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        for ( RenderingOptionListener listener : m_renderingOptionListeners )
        {
          listener.setAntiAliasing(value);
        }
      }
    });

    m_comboBoxTransparencyType.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        for ( RenderingOptionListener listener : m_renderingOptionListeners )
        {
          String currentChoice = (String) m_comboBoxTransparencyType.getSelectedItem();
          TransparencyTypes type = transparencyTypesMap.get(currentChoice);
          listener.setTransparencyType(type);
          if ( type == TransparencyTypes.SORTED_PIXEL )
            m_antiAliasingSliderPanel.setEnabled(false);
          else
            m_antiAliasingSliderPanel.setEnabled(true);
        }
      }
    });

    m_comboBoxColormaps.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        for ( RenderingOptionListener listener : m_renderingOptionListeners )
        {
          PredefColorMapping colormap = PredefColorMapping.valueOf((String) m_comboBoxColormaps.getSelectedItem());
          listener.setColormap(colormap);
        }
      }
    });

    m_fadingSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        for ( RenderingOptionListener listener : m_renderingOptionListeners )
        {
          listener.setFading(value);
        }
      }
    });

    m_pointsButton.addActionListener(this);
    m_edgesButton.addActionListener(this);
    m_facesButton.addActionListener(this);

  }

  public void addRenderingOptionListener(RenderingOptionListener listener)
  {
    m_renderingOptionListeners.add(listener);
  }

  private void initiateMap()
  {
    transparencyTypesMap = new TreeMap<String, SoGLRenderAction.TransparencyTypes>();
    transparencyTypesMap.put("NO_SORT", TransparencyTypes.NO_SORT);
    transparencyTypesMap.put("OPAQUE_FIRST", TransparencyTypes.OPAQUE_FIRST);
    transparencyTypesMap.put("SORTED_OBJECT", TransparencyTypes.SORTED_OBJECT);
    transparencyTypesMap.put("SORTED_PIXEL", TransparencyTypes.SORTED_PIXEL);
  }

  @Override
  public void actionPerformed(ActionEvent e)
  {
    for ( RenderingOptionListener listener : m_renderingOptionListeners )
      listener.edgesVisibilityChanged(m_edgesButton.isSelected());
    for ( RenderingOptionListener listener : m_renderingOptionListeners )
      listener.facesVisibilityChanged(m_facesButton.isSelected());
    for ( RenderingOptionListener listener : m_renderingOptionListeners )
      listener.pointsVisibilityChanged(m_pointsButton.isSelected());
  }

}
