package meshvizxlm.eclipsemeshviz.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;

import javax.swing.JCheckBox;
import javax.swing.JPanel;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

@SuppressWarnings("serial")
public class FullMeshPanel extends JPanel implements ItemListener
{

  private JCheckBox m_visibleCheckBox;

  private ArrayList<FullMeshListener> m_listeners;
  private SliderPanel m_transparencySliderPanel;

  private JCheckBox m_mapPropertyCheckBox;

  /**
   * Create the panel.
   */
  public FullMeshPanel()
  {

    m_listeners = new ArrayList<FullMeshListener>();

    buildUI();
    addListeners();

    // init
    m_visibleCheckBox.setSelected(false);
  }

  @Override
  public String toString()
  {
    return "Full mesh";
  }

  public void addFullMeshListener(FullMeshListener listener)
  {
    m_listeners.add(listener);
  }

  private void buildUI()
  {
    GridBagLayout gridBagLayout = new GridBagLayout();
    gridBagLayout.columnWidths = new int[] { 61, 0 };
    gridBagLayout.rowHeights = new int[] { 18, 18, 18, 18, 18, 0 };
    gridBagLayout.columnWeights = new double[] { 0.0, Double.MIN_VALUE };
    gridBagLayout.rowWeights = new double[] { 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE };
    setLayout(gridBagLayout);

    m_visibleCheckBox = new JCheckBox("Visible");
    GridBagConstraints gbc_m_visibleCheckBox = new GridBagConstraints();
    gbc_m_visibleCheckBox.anchor = GridBagConstraints.WEST;
    gbc_m_visibleCheckBox.insets = new Insets(0, 0, 5, 0);
    gbc_m_visibleCheckBox.gridx = 0;
    gbc_m_visibleCheckBox.gridy = 0;
    add(m_visibleCheckBox, gbc_m_visibleCheckBox);

    m_mapPropertyCheckBox = new JCheckBox("Map property", true);
    GridBagConstraints gbc_m_mapPropertyCheckBox = new GridBagConstraints();
    gbc_m_mapPropertyCheckBox.insets = new Insets(0, 0, 5, 0);
    gbc_m_mapPropertyCheckBox.anchor = GridBagConstraints.WEST;
    gbc_m_mapPropertyCheckBox.gridx = 0;
    gbc_m_mapPropertyCheckBox.gridy = 4;
    add(m_mapPropertyCheckBox, gbc_m_mapPropertyCheckBox);

    m_transparencySliderPanel = new SliderPanel(0, 1, 0, 3);
    m_transparencySliderPanel.addInfoText("Transparency");
    GridBagConstraints gbc_m_slabPosSliderPanel = new GridBagConstraints();
    gbc_m_slabPosSliderPanel.insets = new Insets(0, 0, 5, 0);
    gbc_m_slabPosSliderPanel.anchor = GridBagConstraints.WEST;
    gbc_m_slabPosSliderPanel.gridx = 0;
    gbc_m_slabPosSliderPanel.gridy = 5;
    add(m_transparencySliderPanel, gbc_m_slabPosSliderPanel);

  }

  private void addListeners()
  {
    m_visibleCheckBox.addItemListener(this);

    m_mapPropertyCheckBox.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent arg0)
      {
        for ( FullMeshListener listener : m_listeners )
          listener.skinMapPropertyChanged(m_mapPropertyCheckBox.isSelected());
      }
    });

    m_transparencySliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        for ( FullMeshListener listener : m_listeners )
        {
          listener.transparencyChanged(value);
        }
      }
    });

  }

  @Override
  public void itemStateChanged(ItemEvent e)
  {
    Object source = e.getItemSelectable();

    if ( source == m_visibleCheckBox )
    {
      boolean selected = e.getStateChange() == ItemEvent.SELECTED;

      for ( FullMeshListener listener : m_listeners )
        listener.skinVisibilityChanged(selected);
    }
  }

  public interface FullMeshListener extends DownsamplingListener
  {
    public void skinVisibilityChanged(boolean visible);

    public void skinMapPropertyChanged(boolean selected);

    public void transparencyChanged(float value);
  }

}
