package meshvizxlm.eclipsemeshviz.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

@SuppressWarnings("serial")
public class GeometrySlicePanel extends SliderPanelContainer<GeometrySlicePanel.GeometrySliceListener>
{

  private static final String[] ROTATION_AXIS = { "X", "Y", "Z" };

  private JCheckBox m_visibleCheckBox;
  private JCheckBox m_clippingCheckBox;
  private JComboBox<String> m_axisComboBox;
  private SliderPanel m_angleSliderPanel;

  private ArrayList<GeometrySliceListener> m_listeners;

  /**
   * Create the panel.
   */
  public GeometrySlicePanel()
  {
    m_listeners = new ArrayList<GeometrySlicePanel.GeometrySliceListener>();

    buildUI();
    addListeners();

    m_axisComboBox.setSelectedIndex(0); // X
    m_clippingCheckBox.setEnabled(false);
    m_angleSliderPanel.setEnabled(false);
    m_axisComboBox.setEnabled(false);
  }

  public void addGeometrySliceListener(GeometrySliceListener listener)
  {
    m_listeners.add(listener);
  }

  @Override
  public String toString()
  {
    return "Geometry Slice";
  }

  public void update()
  {
    for ( GeometrySliceListener listener : m_listeners )
      listener.sliceRotAngleChanged(m_axisComboBox.getSelectedIndex(), m_angleSliderPanel.getSliderValue());
  }

  private void buildUI()
  {
    GridBagLayout gridBagLayout = new GridBagLayout();
    gridBagLayout.columnWidths = new int[] { 0, 0 };
    gridBagLayout.rowHeights = new int[] { 0, 0, 0, 0, 0, 0 };
    gridBagLayout.columnWeights = new double[] { 1.0, Double.MIN_VALUE };
    gridBagLayout.rowWeights = new double[] { 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE };
    setLayout(gridBagLayout);

    m_visibleCheckBox = new JCheckBox("Visible");
    GridBagConstraints gbc_visibleCheckBox = new GridBagConstraints();
    gbc_visibleCheckBox.anchor = GridBagConstraints.WEST;
    gbc_visibleCheckBox.insets = new Insets(0, 0, 5, 0);
    gbc_visibleCheckBox.gridx = 0;
    gbc_visibleCheckBox.gridy = 0;
    add(m_visibleCheckBox, gbc_visibleCheckBox);

    m_clippingCheckBox = new JCheckBox("Clipping");
    GridBagConstraints gbc_clippingCheckBox = new GridBagConstraints();
    gbc_clippingCheckBox.insets = new Insets(0, 0, 5, 0);
    gbc_clippingCheckBox.anchor = GridBagConstraints.WEST;
    gbc_clippingCheckBox.gridx = 0;
    gbc_clippingCheckBox.gridy = 3;
    add(m_clippingCheckBox, gbc_clippingCheckBox);

    JPanel panel = new JPanel();
    panel.setBorder(new TitledBorder(null, "Rotation", TitledBorder.LEADING, TitledBorder.TOP, null, null));
    GridBagConstraints gbc_panel = new GridBagConstraints();
    gbc_panel.fill = GridBagConstraints.BOTH;
    gbc_panel.gridx = 0;
    gbc_panel.gridy = 4;
    add(panel, gbc_panel);
    GridBagLayout gbl_panel = new GridBagLayout();
    gbl_panel.columnWidths = new int[] { 0, 0, 0 };
    gbl_panel.rowHeights = new int[] { 0, 0, 0 };
    gbl_panel.columnWeights = new double[] { 0.0, 1.0, Double.MIN_VALUE };
    gbl_panel.rowWeights = new double[] { 0.0, 0.0, Double.MIN_VALUE };
    panel.setLayout(gbl_panel);

    JLabel lblAxis = new JLabel("Axis");
    GridBagConstraints gbc_lblAxis = new GridBagConstraints();
    gbc_lblAxis.anchor = GridBagConstraints.WEST;
    gbc_lblAxis.insets = new Insets(0, 0, 5, 5);
    gbc_lblAxis.gridx = 0;
    gbc_lblAxis.gridy = 0;
    panel.add(lblAxis, gbc_lblAxis);

    m_axisComboBox = new JComboBox<>(ROTATION_AXIS);
    m_axisComboBox.setPreferredSize(new Dimension(50, 20));
    GridBagConstraints gbc_axisComboBox = new GridBagConstraints();
    gbc_axisComboBox.anchor = GridBagConstraints.WEST;
    gbc_axisComboBox.insets = new Insets(0, 0, 5, 0);
    gbc_axisComboBox.gridx = 1;
    gbc_axisComboBox.gridy = 0;
    panel.add(m_axisComboBox, gbc_axisComboBox);

    JLabel lblAngle = new JLabel("Angle");
    GridBagConstraints gbc_lblAngle = new GridBagConstraints();
    gbc_lblAngle.anchor = GridBagConstraints.WEST;
    gbc_lblAngle.insets = new Insets(0, 0, 0, 5);
    gbc_lblAngle.gridx = 0;
    gbc_lblAngle.gridy = 1;
    panel.add(lblAngle, gbc_lblAngle);

    m_angleSliderPanel = new SliderPanel(0, 180, 0);
    GridBagConstraints gbc_angleSliderPanel = new GridBagConstraints();
    gbc_angleSliderPanel.anchor = GridBagConstraints.WEST;
    gbc_angleSliderPanel.fill = GridBagConstraints.VERTICAL;
    gbc_angleSliderPanel.gridx = 1;
    gbc_angleSliderPanel.gridy = 1;
    panel.add(m_angleSliderPanel, gbc_angleSliderPanel);

  }

  private void addListeners()
  {
    m_visibleCheckBox.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        boolean selected = e.getStateChange() == ItemEvent.SELECTED;

        for ( GeometrySliceListener listener : m_listeners )
          listener.sliceVisibilityChanged(selected);

        m_clippingCheckBox.setEnabled(selected);
        m_angleSliderPanel.setEnabled(selected);
        m_axisComboBox.setEnabled(selected);
      }
    });

    m_clippingCheckBox.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        for ( GeometrySliceListener listener : m_listeners )
          listener.sliceClippingChanged(e.getStateChange() == ItemEvent.SELECTED);
      }
    });

    m_axisComboBox.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        for ( GeometrySliceListener listener : m_listeners )
          listener.sliceRotAxisChanged(m_axisComboBox.getSelectedIndex());
        m_angleSliderPanel.setSliderValue(0);
      }
    });

    m_angleSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        for ( GeometrySliceListener listener : m_listeners )
        {
          if ( !m_sliderDragStart )
            listener.startDownsampling();
          listener.sliceRotAngleChanged(m_axisComboBox.getSelectedIndex(), value);
        }
      };
    });

    addDownsamplingBehaviours(m_angleSliderPanel);
  }

  @Override
  protected ArrayList<GeometrySliceListener> getDownsamplingListeners()
  {
    return m_listeners;
  }

  public interface GeometrySliceListener extends DownsamplingListener
  {
    public void sliceVisibilityChanged(boolean visible);

    public void sliceClippingChanged(boolean active);

    public void sliceRotAxisChanged(int axis);

    public void sliceRotAngleChanged(int axis, float angle);
  }
}
