package meshvizxlm.eclipsemeshviz.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;

import javax.swing.JCheckBox;
import javax.swing.JPanel;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

public class HullPanel extends JPanel implements ItemListener
{

  private ArrayList<HullListener> m_listeners;

  private SliderPanel m_hullTransparencySliderPanel;

  private JCheckBox m_visibleCheckBox;
  private JCheckBox m_outlineCheckBox;

  public HullPanel()
  {
    m_listeners = new ArrayList<HullListener>();

    buildUI();
    addListeners();

    // init
    m_visibleCheckBox.setSelected(true);
  }

  private void addListeners()
  {
    m_visibleCheckBox.addItemListener(this);
    m_outlineCheckBox.addItemListener(this);

    m_hullTransparencySliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        for ( HullListener listener : m_listeners )
        {
          listener.hullTransparencyChanged(value);
        }
      }
    });
  }

  @Override
  public String toString()
  {
    return "Hull";
  }

  public void addHullListener(HullListener listener)
  {
    m_listeners.add(listener);
  }

  private void buildUI()
  {

    GridBagLayout gridBagLayout = new GridBagLayout();
    gridBagLayout.columnWidths = new int[] { 61, 0 };
    gridBagLayout.rowHeights = new int[] { 18, 18, 18, 18, 18, 0 };
    gridBagLayout.columnWeights = new double[] { 0.0, Double.MIN_VALUE };
    gridBagLayout.rowWeights = new double[] { 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE };
    setLayout(gridBagLayout);

    m_visibleCheckBox = new JCheckBox("Hull");
    GridBagConstraints gbc_m_visibleCheckBox = new GridBagConstraints();
    gbc_m_visibleCheckBox.anchor = GridBagConstraints.WEST;
    gbc_m_visibleCheckBox.insets = new Insets(0, 0, 5, 0);
    gbc_m_visibleCheckBox.gridx = 0;
    gbc_m_visibleCheckBox.gridy = 0;
    add(m_visibleCheckBox, gbc_m_visibleCheckBox);

    m_hullTransparencySliderPanel = new SliderPanel(0, 1, 0, 3);
    m_hullTransparencySliderPanel.addInfoText("Transparency");
    GridBagConstraints gbc_m_slabPosSliderPanel = new GridBagConstraints();
    gbc_m_slabPosSliderPanel.insets = new Insets(0, 0, 5, 0);
    gbc_m_slabPosSliderPanel.anchor = GridBagConstraints.WEST;
    gbc_m_slabPosSliderPanel.gridx = 1;
    gbc_m_slabPosSliderPanel.gridy = 0;
    // Be careful this value refers to the default value of the transparency
    // slider
    // Here we set the default value of the slider not the displayed
    // transparency
    // See OivSceneGraph
    m_hullTransparencySliderPanel.setSliderValue((float) 0.8);
    add(m_hullTransparencySliderPanel, gbc_m_slabPosSliderPanel);

    m_outlineCheckBox = new JCheckBox("Outline");
    GridBagConstraints gbc_m_outlineCheckBox = new GridBagConstraints();
    gbc_m_outlineCheckBox.anchor = GridBagConstraints.WEST;
    gbc_m_outlineCheckBox.insets = new Insets(0, 0, 5, 0);
    gbc_m_outlineCheckBox.gridx = 0;
    gbc_m_outlineCheckBox.gridy = 1;
    add(m_outlineCheckBox, gbc_m_outlineCheckBox);
  }

  @Override
  public void itemStateChanged(ItemEvent e)
  {
    Object source = e.getItemSelectable();
    if ( source == m_visibleCheckBox )
    {
      boolean selected = e.getStateChange() == ItemEvent.SELECTED;

      for ( HullListener listener : m_listeners )
        listener.hullVisibilityChanged(selected);
      m_hullTransparencySliderPanel.setEnabled(selected);
    }
    if ( source == m_outlineCheckBox )
    {
      boolean selected = e.getStateChange() == ItemEvent.SELECTED;

      for ( HullListener listener : m_listeners )
        listener.hullOutlineVisibilityChanged(selected);
    }
  }

  public interface HullListener
  {
    public void hullVisibilityChanged(boolean visible);

    public void hullTransparencyChanged(float value);

    void hullOutlineVisibilityChanged(boolean visible);
  }
}
