package meshvizxlm.eclipsemeshviz.gui;

import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

import meshvizxlm.eclipsemeshviz.pillargrid.PillarGrid;
import meshvizxlm.eclipsemeshviz.wrappers.PillarMesh;
import meshvizxlm.eclipsemeshviz.wrappers.geometry.PillarGeometry;
import meshvizxlm.eclipsemeshviz.wrappers.topology.PillarTopology;

@SuppressWarnings("serial")
public class InfoPanel extends JPanel implements MeshChangedListener
{

  private JLabel m_gridInfoLabel;
  private JLabel m_activeCellsLabel;
  private JLabel m_gridMemoryLabel;
  private JLabel m_wrapperMemoryLabel;

  public InfoPanel()
  {
    buildUI();
  }

  private void buildUI()
  {
    BoxLayout boxLayout = new BoxLayout(this, BoxLayout.Y_AXIS);
    setLayout(boxLayout);

    m_gridInfoLabel = new JLabel();
    add(m_gridInfoLabel);
    m_activeCellsLabel = new JLabel();
    add(m_activeCellsLabel);
    m_gridMemoryLabel = new JLabel();
    add(m_gridMemoryLabel);
    m_wrapperMemoryLabel = new JLabel();
    add(m_wrapperMemoryLabel);
  }

  @Override
  public String toString()
  {
    return "Info";
  }

  @SuppressWarnings("unchecked")
  @Override
  public void meshChanged(PillarMesh<PillarGrid> newMesh)
  {
    String memUnit[] = new String[] { "KB", "MB", "GB" };
    int index = 0;
    double gridMemoryFp = newMesh.getGrid().getMemoryFootPrint() / 1024.0;
    double meshMemoryFp = ((PillarGeometry) newMesh.getGeometry()).getMemoryFootPrint() / 1024.0;
    meshMemoryFp += ((PillarTopology<PillarGrid>) newMesh.getTopology()).getMemoryFootPrint() / 1024.0;

    while ( gridMemoryFp > 1024 && index < 3 )
    {
      gridMemoryFp /= 1024.0;
      meshMemoryFp /= 1024.0;
      ++index;
    }
    ;

    m_gridInfoLabel.setText("Grid dimensions I/J/K: " + newMesh.getGrid().getDimI() + " x "
        + newMesh.getGrid().getDimJ() + " x " + newMesh.getGrid().getDimK());

    PillarTopology<PillarGrid> topology = (PillarTopology<PillarGrid>) newMesh.getTopology();
    String unit = "";
    long numActiveCells = topology.getNumActiveCells();
    if ( numActiveCells > 1e6 )
    {
      unit = " million";
      numActiveCells /= 1e6;
    }
    m_activeCellsLabel.setText("#Active cells: " + numActiveCells + unit);

    m_gridMemoryLabel.setText("Grid memory footprint : " + String.format("%1$,.1f", gridMemoryFp) + memUnit[index]);
    m_wrapperMemoryLabel.setText("Wrapper memory footprint : " + String.format("%1$,.1f", meshMemoryFp)
        + memUnit[index]);
  }

  @Override
  public void propertyChanged(PillarMesh<PillarGrid> newMesh)
  {
    // TODO Auto-generated method stub

  }
}
