package meshvizxlm.eclipsemeshviz.gui;

import java.awt.FlowLayout;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import com.openinventor.meshvizxlm.mesh.Dimension;

import meshvizxlm.eclipsemeshviz.gui.SlabAxisPanel.SlabListener;

@SuppressWarnings("serial")
public class SlabPanel extends JPanel
{
  public final SlabAxisPanel xSlab;
  public final SlabAxisPanel ySlab;
  public final SlabAxisPanel zSlab;

  public SlabPanel()
  {
    xSlab = new SlabAxisPanel(Dimension.I);
    ySlab = new SlabAxisPanel(Dimension.J);
    zSlab = new SlabAxisPanel(Dimension.K);

    buildUI();
  }

  @Override
  public String toString()
  {
    return "Slabs";
  }

  private void buildUI()
  {
    FlowLayout flowLayout;

    JPanel xSlabPanel = new JPanel();
    xSlabPanel.setBorder(new TitledBorder(null, "Slab I", TitledBorder.LEADING, TitledBorder.TOP, null, null));
    flowLayout = (FlowLayout) xSlabPanel.getLayout();
    flowLayout.setAlignment(FlowLayout.LEFT);

    xSlabPanel.add(xSlab);

    JPanel ySlabPanel = new JPanel();
    ySlabPanel.setBorder(new TitledBorder(null, "Slab J", TitledBorder.LEADING, TitledBorder.TOP, null, null));
    ySlabPanel.add(ySlab);
    flowLayout = (FlowLayout) ySlabPanel.getLayout();
    flowLayout.setAlignment(FlowLayout.LEFT);

    JPanel zSlabPanel = new JPanel();
    zSlabPanel.setBorder(new TitledBorder(null, "Slab K", TitledBorder.LEADING, TitledBorder.TOP, null, null));
    zSlabPanel.add(zSlab);
    flowLayout = (FlowLayout) zSlabPanel.getLayout();
    flowLayout.setAlignment(FlowLayout.LEFT);

    setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
    add(xSlabPanel);
    add(ySlabPanel);
    add(zSlabPanel);
  }

  public void addSlabListener(SlabListener listener)
  {
    xSlab.addSlabListener(listener);
    ySlab.addSlabListener(listener);
    zSlab.addSlabListener(listener);
  }
}
