package meshvizxlm.eclipsemeshviz.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

import javax.swing.JPanel;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

@SuppressWarnings("serial")
public abstract class SliderPanelContainer<T extends DownsamplingListener> extends JPanel
{
  protected boolean m_sliderDragStart;

  protected SliderPanelContainer()
  {
    m_sliderDragStart = true;
  }

  protected abstract ArrayList<T> getDownsamplingListeners();

  protected void addDownsamplingBehaviours(final SliderPanel slider)
  {
    MouseMotionListener sliderMouseMotionListener = new MouseMotionAdapter()
    {
      @Override
      public void mouseDragged(MouseEvent e)
      {
        if ( m_sliderDragStart && slider.isEnabled() && slider.isSliderBoxSelected() )
        {
          for ( DownsamplingListener listener : getDownsamplingListeners() )
            listener.startDownsampling();
          m_sliderDragStart = false;
        }
      }
    };

    MouseListener sliderMouseListener = new MouseAdapter()
    {
      @Override
      public void mouseReleased(MouseEvent e)
      {
        if ( !m_sliderDragStart )
        {
          for ( DownsamplingListener listener : getDownsamplingListeners() )
            listener.finishDownsampling();
          m_sliderDragStart = true;
        }
        else
        {
          for ( DownsamplingListener listener : getDownsamplingListeners() )
          {
            listener.startDownsampling();
            listener.finishDownsampling();
          }
        }
      }

      @Override
      public void mousePressed(MouseEvent e)
      {
        if ( m_sliderDragStart && !slider.isSliderBoxSelected() )
        {
          for ( DownsamplingListener listener : getDownsamplingListeners() )
            listener.disableFullResolution();
        }
      }
    };

    slider.addSliderMouseListener(sliderMouseListener);
    slider.addSliderMouseMotionListener(sliderMouseMotionListener);
  }
}
