package meshvizxlm.eclipsemeshviz.wrappers;

import com.openinventor.meshvizxlm.mesh.MiVolumeMeshHexahedronIjk;
import com.openinventor.meshvizxlm.mesh.geometry.MiGeometryI;
import com.openinventor.meshvizxlm.mesh.topology.MiHexahedronTopologyExplicitIjk;

import meshvizxlm.eclipsemeshviz.DemoSettings;
import meshvizxlm.eclipsemeshviz.pillargrid.PillarGrid;
import meshvizxlm.eclipsemeshviz.wrappers.geometry.PillarGeometry;
import meshvizxlm.eclipsemeshviz.wrappers.property.AnimatedPillarPorosity;
import meshvizxlm.eclipsemeshviz.wrappers.property.AnimatedPillarProperty;
import meshvizxlm.eclipsemeshviz.wrappers.property.BoundedProperty;
import meshvizxlm.eclipsemeshviz.wrappers.property.PillarProperty;
import meshvizxlm.eclipsemeshviz.wrappers.topology.PillarTopology;

public class PillarMesh<T extends PillarGrid> extends EclipseMesh
    implements MiVolumeMeshHexahedronIjk<MiHexahedronTopologyExplicitIjk, MiGeometryI>
{
  protected String m_name;
  protected PillarGrid m_grid;
  protected PillarProperty m_currentDataset;
  protected AnimatedPillarProperty m_depth;
  protected AnimatedPillarPorosity m_porosity;
  protected PillarGeometry m_geometry;
  protected PillarTopology<T> m_topology;
  private final double[] m_bbsize = new double[3];

  public PillarMesh(T grid)
  {
    m_name = "PillarMesh";
    m_grid = grid;
    m_depth = new AnimatedPillarProperty(grid);
    m_porosity = new AnimatedPillarPorosity(grid);
    if ( grid.isPorosityAvailable() == true )
      m_currentDataset = m_porosity;
    else
      m_currentDataset = m_depth;

    long t1 = System.currentTimeMillis();
    m_geometry = new PillarGeometry(grid);
    m_topology = PillarTopology.getNewInstance(grid);
    long t2 = System.currentTimeMillis();

    m_numCellsI = getTopology().getNumCellsI();
    m_numCellsJ = getTopology().getNumCellsJ();
    m_numCellsK = getTopology().getNumCellsK();

    displayCreationTime(t2 - t1);
    displayInfo();
  }

  protected PillarMesh(T grid, PillarGeometry geometry, String name)
  {
    m_name = name;
    m_grid = grid;
    m_depth = new AnimatedPillarProperty(grid);
    m_porosity = new AnimatedPillarPorosity(grid);
    if ( grid.isPorosityAvailable() == true )
      m_currentDataset = m_porosity;
    else
      m_currentDataset = m_depth;
    m_geometry = geometry;

    m_numCellsI = grid.getDimI();
    m_numCellsJ = grid.getDimJ();
    m_numCellsK = grid.getDimK();
  }

  protected void displayCreationTime(long elapsedTime)
  {
    DemoSettings.displayTime(m_name + " created", elapsedTime);
  }

  protected void displayInfo()
  {
    System.out.print(m_name + " made of " + m_topology.getEndNodeId() + " point(s) and " + m_topology.getNumCells()
        + " cells");
    if ( m_topology.hasDeadCells() )
      System.out.print(" including " + m_grid.getNumNonActiveCells() + " dead cells");
    System.out.println();
  }

  public PillarGrid getGrid()
  {
    return m_grid;
  }

  @Override
  public BoundedProperty getDataSet()
  {
    return m_currentDataset;
  }

  public void setCurrentDatasetToDepth()
  {
    m_currentDataset = m_depth;
  }

  public void setCurrentDatasetToPorosity()
  {
    m_currentDataset = m_porosity;
  }

  @Override
  public MiGeometryI getGeometry()
  {
    return m_geometry;
  }

  @Override
  public MiHexahedronTopologyExplicitIjk getTopology()
  {
    return m_topology;
  }

  @Override
  public double getXCenter()
  {
    return (m_grid.getXMax() + m_grid.getXMin()) / 2.0f;
  }

  @Override
  public double getYCenter()
  {
    return (m_grid.getYMax() + m_grid.getYMin()) / 2.0f;
  }

  @Override
  public double getZCenter()
  {
    return (m_grid.getZMax() + m_grid.getZMin()) / 2.0f;
  }

  @Override
  public double[] getBBSize()
  {
    m_bbsize[0] = m_grid.getXMax() - m_grid.getXMin();
    m_bbsize[1] = m_grid.getYMax() - m_grid.getYMin();
    m_bbsize[2] = m_grid.getZMax() - m_grid.getZMin();
    return m_bbsize;
  }

}
