package meshvizxlm.eclipsemeshviz.wrappers.topology;

import meshvizxlm.eclipsemeshviz.DemoSettings;
import meshvizxlm.eclipsemeshviz.pillargrid.PillarGridJIK;

public class PillarJIKGridTopology extends PillarTopology<PillarGridJIK>
{

  public PillarJIKGridTopology(PillarGridJIK grid)
  {
    super(grid);
  }

  @Override
  public long[] getCellNodeIndices(int i, int j, int k, long[] nodeIndices)
  {
    float[] zcorns;
    int[] zcornId = new int[8];
    long corner;
    float zcorn;

    if ( null == nodeIndices || nodeIndices.length < 8 )
      nodeIndices = new long[8];

    if ( DemoSettings.HORIZONTAL_FAULTS )
      zcorns = new float[8];
    else
      zcorns = new float[4];

    nodeIndices[0] = zcornId[0] = m_grid.getPillarZCorns(i, j, k, zcorns);
    zcornId[1] = m_grid.getPillarZCorns(i + 1, j, k, zcorns);
    if ( zcorns[1] != zcorns[0] )
      ++zcornId[1];
    nodeIndices[1] = zcornId[1];

    for ( int n = 2; n < m_numCorners; ++n )
    {
      zcornId[n] = m_grid.getPillarZCorns(i + s_direction[n][0], j + s_direction[n][1], k + s_direction[n][2], zcorns);
      corner = 0;
      zcorn = zcorns[n];
      while ( zcorn != zcorns[(int) corner] )
        ++corner;
      zcornId[n] += corner;
    }

    nodeIndices[2] = zcornId[2];
    nodeIndices[3] = zcornId[3];

    if ( DemoSettings.HORIZONTAL_FAULTS )
    {
      nodeIndices[4] = zcornId[4];
      nodeIndices[5] = zcornId[5];
      nodeIndices[6] = zcornId[6];
      nodeIndices[7] = zcornId[7];
    }
    else
    {
      if ( k + 1 < m_grid.getDimK() )
      {
        nodeIndices[4] = m_grid.getNextUpperCellFaceZCornId(zcornId[0]);
        nodeIndices[5] = m_grid.getNextUpperCellFaceZCornId(zcornId[1]);
        nodeIndices[6] = m_grid.getNextUpperCellFaceZCornId(zcornId[2]);
        nodeIndices[7] = m_grid.getNextUpperCellFaceZCornId(zcornId[3]);
      }
      else
      {
        nodeIndices[4] = m_grid.getNextUpperFaceZCornId(zcornId[0]);
        nodeIndices[5] = m_grid.getNextUpperFaceZCornId(zcornId[1]);
        nodeIndices[6] = m_grid.getNextUpperFaceZCornId(zcornId[2]);
        nodeIndices[7] = m_grid.getNextUpperFaceZCornId(zcornId[3]);
      }
    }

    return nodeIndices;
  }
}
