package meshvizxlm.eclipsemeshviz.wrappers.topology;

import com.openinventor.meshvizxlm.MxTimeStamp;
import com.openinventor.meshvizxlm.mesh.StorageLayoutIJK;
import com.openinventor.meshvizxlm.mesh.topology.MiHexahedronTopologyExplicitIjk;

import meshvizxlm.eclipsemeshviz.DemoSettings;
import meshvizxlm.eclipsemeshviz.pillargrid.PillarEGrid;
import meshvizxlm.eclipsemeshviz.pillargrid.PillarGrid;
import meshvizxlm.eclipsemeshviz.pillargrid.PillarGridJIK;

public abstract class PillarTopology<T extends PillarGrid> implements MiHexahedronTopologyExplicitIjk
{
  protected T m_grid;
  private long m_timeStamp;
  protected int m_numCorners;

  @SuppressWarnings("unchecked")
  public static <T extends PillarGrid> PillarTopology<T> getNewInstance(T grid)
  {
    if ( grid instanceof PillarEGrid )
      return (PillarTopology<T>) new PillarEGridTopology((PillarEGrid) grid);

    return (PillarTopology<T>) new PillarJIKGridTopology((PillarGridJIK) grid);
  }

  public PillarTopology(T grid)
  {
    m_timeStamp = MxTimeStamp.getTimeStamp();
    m_grid = grid;
    m_numCorners = DemoSettings.HORIZONTAL_FAULTS ? 8 : 4;
  }

  @Override
  public StorageLayoutIJK getStorageLayout()
  {
    return StorageLayoutIJK.JIK;
  }

  /**
   * Returns the max node id +1 used by this topology. This topology used only
   * node index in the interval [beginNodeId,EndNodeId[. Thus the maximum node
   * index used by the topology is getEndNodeId() -1 and the number of nodes
   * used by this topology is getEndNodeId()-getBeginNodeId().
   */
  @Override
  public long getEndNodeId()
  {
    return m_grid.getNumZCorns();
  }

  /**
   * Returns the number of cells on the first logical axis.
   */
  @Override
  public int getNumCellsI()
  {
    return m_grid.getDimI();
  }

  /**
   * Returns the number of cells on the second logical axis.
   */
  @Override
  public int getNumCellsJ()
  {
    return m_grid.getDimJ();
  }

  /**
   * Returns the number of cells on the third logical axis.
   */
  @Override
  public int getNumCellsK()
  {
    return m_grid.getDimK();
  }

  @Override
  public long getTimeStamp()
  {
    return m_timeStamp;
  }

  @Override
  public boolean hasDeadCells()
  {
    return m_grid.getNumNonActiveCells() > 0;
  }

  /**
   * Returns true if the cell of index (i,j,k) should be ignored. This value is
   * ignored if the hasDeadCell() method returns false. The default
   * implementation returns always false.
   *
   * @param (i,j,k) the index of the cell to check
   */
  @Override
  public boolean isDead(int i, int j, int k)
  {
    return !m_grid.isValid(i, j, k);
  }

  /**
   * Returns the number of cells
   */
  public int getNumCells()
  {
    return m_grid.getDimI() * m_grid.getDimJ() * m_grid.getDimK();
  }

  /**
   * Returns the number of active cells
   *
   * @return number of active cells
   */
  public long getNumActiveCells()
  {
    return getNumCells() - m_grid.getNumNonActiveCells();
  }

  protected static final int[][] s_direction = { { 0, 0, 0 }, { 1, 0, 0 }, { 1, 1, 0 }, { 0, 1, 0 }, { 0, 0, 1 },
      { 1, 0, 1 }, { 1, 1, 1 }, { 0, 1, 1 } };

  @Override
  public abstract long[] getCellNodeIndices(int i, int j, int k, long[] nodeIndices);

  @Override
  public long getBeginNodeId()
  {
    throw new RuntimeException();
  }

  public long getMemoryFootPrint()
  {
    return 0;
  }
}
