package meshvizxlm.mapping.pointprobe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

import com.openinventor.inventor.SoPickedPoint;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.misc.callbacks.SoEventCallbackCB;
import com.openinventor.inventor.nodes.*;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.InteractionMode;
import com.openinventor.meshvizxlm.MxMeshViz;
import com.openinventor.meshvizxlm.mapping.nodes.*;
import com.openinventor.meshvizxlm.mesh.cell.MiCellFilterI;
import com.openinventor.meshvizxlm.mesh.cell.MiCellFilterIjk;
import com.openinventor.meshvizxlm.meshextracted.data.MeXScalardSetI;
import com.openinventor.meshvizxlm.meshextracted.data.MeXVec3dSetI;

import meshvizxlm.mapping.MyVec3Set;
import meshvizxlm.mesh.MbSampleMeshBuilder;
import meshvizxlm.mesh.data.MbScalarSetI;
import meshvizxlm.mesh.data.MbScalarSetIjk;
import meshvizxlm.mesh.volumes.MbHexahedronMeshIjk;
import meshvizxlm.mesh.volumes.MbVertexHexahedronMeshIjk;
import meshvizxlm.mesh.volumes.MbVolumeMeshHexahedron;
import meshvizxlm.mesh.volumes.MbVolumeMeshTetrahedron;
import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private static DecimalFormat scFormat = new DecimalFormat("#.###E0", new DecimalFormatSymbols(Locale.ENGLISH));
  private static DecimalFormat decFormat = new DecimalFormat("#.######", new DecimalFormatSymbols(Locale.ENGLISH));

  class MyCellFilterI implements MiCellFilterI
  {
    @Override
    public boolean acceptCell(long cellIndex)
    {
      int index = (int) cellIndex;
      int k = index / (NUM_CELL_I * NUM_CELL_J);
      int ij = index % (NUM_CELL_I * NUM_CELL_J);
      int j = ij / NUM_CELL_I;
      int i = ij % NUM_CELL_I;

      if ( NUM_CELL_I / 3. < i && i <= 2 * NUM_CELL_I / 3. && NUM_CELL_J / 3. < j && j <= 2 * NUM_CELL_J / 3.
          && k > NUM_CELL_K / 2. )
        return false;

      return true;
    }

    @Override
    public long getTimeStamp()
    {
      return 0;
    }
  }

  class MyCellFilterIjk implements MiCellFilterIjk
  {
    @Override
    public boolean acceptCell(int i, int j, int k)
    {
      if ( NUM_CELL_I / 3. < i && i <= 2 * NUM_CELL_I / 3. && NUM_CELL_J / 3. < j && j <= 2 * NUM_CELL_J / 3.
          && k > NUM_CELL_K / 2. )
        return false;

      return true;
    }

    @Override
    public long getTimeStamp()
    {
      return 0;
    }
  }

  class ProbeCallback implements MoMeshPointProbe.MoProbeCallback
  {

    private SoSwitch m_displaySwitch;
    private SoText2 m_indexText;
    private SoText2 m_valueText;

    public ProbeCallback(SoSwitch displaySwitch, SoText2 indexText, SoText2 valueText)
    {
      m_displaySwitch = displaySwitch;
      m_indexText = indexText;
      m_valueText = valueText;
    }

    @Override
    public void motionCallback(long cellId, MeXScalardSetI scalars, MeXVec3dSetI vectors)
    {
      long[] cellIds = new long[1];
      cellIds[0] = cellId;
      motionCallback(cellIds, scalars, vectors);
    }

    @Override
    public void motionCallback(long cellIdI, long cellIdJ, MeXScalardSetI scalars, MeXVec3dSetI vectors)
    {
      long[] cellIds = new long[1];
      cellIds[0] = cellIdI;
      cellIds[1] = cellIdJ;
      motionCallback(cellIds, scalars, vectors);
    }

    @Override
    public void motionCallback(long cellIdI, long cellIdJ, long cellIdK, MeXScalardSetI scalars, MeXVec3dSetI vectors)
    {
      long[] cellIds = new long[3];
      cellIds[0] = cellIdI;
      cellIds[1] = cellIdJ;
      cellIds[2] = cellIdK;
      motionCallback(cellIds, scalars, vectors);
    }

    private void motionCallback(long[] cellIds, MeXScalardSetI scalars, MeXVec3dSetI vectors)
    {
      if ( cellIds[0] == MxMeshViz.UNDEFINED_ID )
        m_displaySwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
      else
      {
        m_displaySwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);

        StringBuffer buf = new StringBuffer("cell: ");
        for ( long id : cellIds )
        {
          buf.append(id);
          buf.append(" ");
        }
        m_indexText.string.setValue(buf.toString());

        buf = new StringBuffer();
        if ( scalars.getSize() > 0 )
        {
          buf.append("value: ");
          buf.append(format(scalars.get(0)));
          buf.append(" ");
        }
        if ( vectors.getSize() > 0 )
        {
          double[] vec = vectors.get(0);
          buf.append("vector: ");
          buf.append("(");
          buf.append(format(vec[0]));
          buf.append(",");
          buf.append(format(vec[1]));
          buf.append(",");
          buf.append(format(vec[2]));
          buf.append(")");
          buf.append(" ");
        }
        m_valueText.string.setValue(buf.toString());
      }
    }

    private String format(double d)
    {
      if ( d == 0 || (d >= 0.00001 && d < 10000) || (d <= -0.00001 && d > -10000) )
        return decFormat.format(d);
      return scFormat.format(d);
    }
  }

  class MouseMoveCB extends SoEventCallbackCB
  {
    private MoMeshPointProbe m_pointProbe;

    public MouseMoveCB(MoMeshPointProbe pointProbe)
    {
      m_pointProbe = pointProbe;
    }

    @Override
    public void invoke(SoEventCallback eventCB)
    {
      if ( m_renderArea.getRenderArea().getInteractionMode() == InteractionMode.NAVIGATION )
        return;

      // set picking radius to 0 to benefit from GPU accelerated picking
      eventCB.getAction().setPickRadius(0.f);
      SoPickedPoint pickedPoint = eventCB.getPickedPoint();
      if ( pickedPoint == null )
        m_pointProbe.position.setValue(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
      else
        m_pointProbe.position.setValue(pickedPoint.getPoint());
    }
  }

  public static final int NUM_CELL_I = 11;
  public static final int NUM_CELL_J = 15;
  public static final int NUM_CELL_K = 17;

  private IViewerExaminer m_renderArea;
  private MbVolumeMeshHexahedron m_meshHexa;
  private MbHexahedronMeshIjk m_meshHexaIjk;
  private MbVertexHexahedronMeshIjk m_meshVertexHexaIjk;
  private MbSampleMeshBuilder m_meshBuilder;
  private MoMesh m_moMesh;
  private MoPredefinedColorMapping m_colMap;
  private SoRotation m_cameraOrientation;
  private SoSwitch m_skinSwitch;
  private MoScalarSetI m_moScalarSetI;
  private MoScalarSetIjk m_moScalarSetIjk;
  private MoVec3SetIjk m_moVec3SetIjk;
  private SoSwitch m_cellFilterSwitch;
  private MoCellFilter m_moCellFilter;
  private MyCellFilterI m_cellFilterI;
  private MyCellFilterIjk m_cellFilterIjk;

  public Main()
  {
    double[] min = { 0, 0, 0 };
    double[] max = { 10, 10, 10 };
    m_meshBuilder = new MbSampleMeshBuilder();

    m_meshHexa = m_meshBuilder.getMeshHexahedron(NUM_CELL_I, NUM_CELL_J, NUM_CELL_K, min, max);
    m_meshHexaIjk = null;
    m_meshVertexHexaIjk = null;

    m_cellFilterI = new MyCellFilterI();
    m_cellFilterIjk = new MyCellFilterIjk();
  }

  @Override
  public void start()
  {
    SoSeparator root = buildSceneGraph();

    m_renderArea = ViewerComponentsFactory.createViewerExaminer();
    m_renderArea.setSceneGraph(root);
    m_cameraOrientation.rotation.connectFrom(m_renderArea.getRenderArea().getSceneInteractor().getCamera().orientation);
    m_renderArea.viewAll();

    // SWING part
    final JCheckBox filterBox = new JCheckBox("Cell filter");
    filterBox.setSelected(m_cellFilterSwitch.whichChild.getValue() == SoSwitch.SO_SWITCH_ALL);
    filterBox.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        if ( filterBox.isSelected() )
          m_cellFilterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
        else
          m_cellFilterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
      }
    });

    JLabel label = new JLabel("Mesh       ");
    String[] items = new String[] { "Tetrahedron", "Hexahedron", "Hexahedron IJK", "Vertex Hexahedron IJK" };
    final JComboBox<String> sliceBox = new JComboBox<>(items);
    sliceBox.setSelectedIndex(1);
    sliceBox.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        switch ( sliceBox.getSelectedIndex() )
        {
        case 0 : // Tetrahedron
          MbVolumeMeshTetrahedron meshTetra = m_meshBuilder.getMeshTetrahedron();
          m_moMesh.setMesh(meshTetra);
          MbScalarSetI scalarSet = meshTetra.getScalarSet("$ScalarSetX");
          m_moScalarSetI.setScalarSet(scalarSet);
          m_colMap.minValue.setValue((float) scalarSet.getMin());
          m_colMap.maxValue.setValue((float) scalarSet.getMax());
          m_cellFilterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
          filterBox.setEnabled(false);
          break;
        case 1 : // hexahedron
          m_moMesh.setMesh(m_meshHexa);
          scalarSet = m_meshHexa.getScalarSet("$ScalarSetX");
          m_moScalarSetI.setScalarSet(scalarSet);
          m_colMap.minValue.setValue((float) scalarSet.getMin());
          m_colMap.maxValue.setValue((float) scalarSet.getMax());
          m_moCellFilter.setCellFilter(m_cellFilterI);
          if ( filterBox.isSelected() )
            m_cellFilterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
          filterBox.setEnabled(true);
          break;
        case 2 : // hexa IJK
          if ( m_meshHexaIjk == null )
            m_meshHexaIjk = m_meshBuilder.getHexahedronMeshIjk(NUM_CELL_I, NUM_CELL_J, NUM_CELL_K,
                new double[] { 0, 0, 0 }, new double[] { 10, 10, 10 });
          m_moMesh.setMesh(m_meshHexaIjk);
          scalarSet = m_meshHexaIjk.getScalarSet("$ScalarSetX");
          m_colMap.minValue.setValue((float) scalarSet.getMin());
          m_colMap.maxValue.setValue((float) scalarSet.getMax());
          m_moScalarSetI.setScalarSet(scalarSet);
          m_moCellFilter.setCellFilter(m_cellFilterIjk);
          if ( filterBox.isSelected() )
            m_cellFilterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
          filterBox.setEnabled(true);
          break;
        case 3 : // vertex hexa IJK
          if ( m_meshVertexHexaIjk == null )
          {
            m_meshVertexHexaIjk = m_meshBuilder.getVertexHexahedronMeshIjk(NUM_CELL_I, NUM_CELL_J, NUM_CELL_K,
                new double[] { 0, 0, 0 }, new double[] { 10, 10, 10 });
            m_moVec3SetIjk.setVec3Set(m_meshVertexHexaIjk.getVec3SetIjk("$CellCenter"));
          }
          m_moMesh.setMesh(m_meshVertexHexaIjk);
          MbScalarSetIjk scalarSetIjk = m_meshVertexHexaIjk.getScalarSetIjk("$CellId");
          m_colMap.minValue.setValue((float) scalarSetIjk.getMin());
          m_colMap.maxValue.setValue((float) scalarSetIjk.getMax());
          m_moScalarSetIjk.setScalarSet(scalarSetIjk);
          m_moCellFilter.setCellFilter(m_cellFilterIjk);
          if ( filterBox.isSelected() )
            m_cellFilterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
          filterBox.setEnabled(true);
          break;
        default:
          break;
        }
      }
    });

    JPanel meshPanel = new JPanel();
    meshPanel.setLayout(new BoxLayout(meshPanel, BoxLayout.X_AXIS));
    meshPanel.add(label);
    meshPanel.add(sliceBox);

    JPanel panel2 = new JPanel(new BorderLayout());
    panel2.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED, null, null));
    panel2.add(filterBox, BorderLayout.NORTH);
    panel2.add(meshPanel, BorderLayout.CENTER);

    final Component component = m_renderArea.getComponent();
    component.setPreferredSize(new Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(panel2, BorderLayout.SOUTH);
  }

  @Override
  public void stop()
  {
    m_renderArea.dispose();
  }

  private SoSeparator buildSceneGraph()
  {
    SoShapeHints sh = new SoShapeHints();
    sh.vertexOrdering.setValue(SoShapeHints.VertexOrderings.CLOCKWISE);

    m_moMesh = new MoMesh();
    m_moMesh.setMesh(m_meshHexa);

    MbScalarSetI scalarSet = m_meshHexa.getScalarSet("$ScalarSetX");

    m_colMap = new MoPredefinedColorMapping();
    // adjust range to scalar set 1
    m_colMap.minValue.setValue((float) scalarSet.getMin());
    m_colMap.maxValue.setValue((float) scalarSet.getMax());
    m_colMap.predefColorMap.setValue(MoPredefinedColorMapping.PredefColorMapping.STANDARD);

    m_moScalarSetI = new MoScalarSetI();
    m_moScalarSetI.setScalarSet(scalarSet);

    m_moScalarSetIjk = new MoScalarSetIjk();

    // Vector field
    MyVec3Set myVec3set = new MyVec3Set(NUM_CELL_I, NUM_CELL_J, NUM_CELL_K);
    MoVec3SetI moVec3Set = new MoVec3SetI();
    moVec3Set.setVec3Set(myVec3set);

    m_moVec3SetIjk = new MoVec3SetIjk();

    MoDataBinding dataBinding = new MoDataBinding();
    dataBinding.dataBinding.setValue(MoDataBinding.DataBinding.PER_NODE);

    m_moCellFilter = new MoCellFilter();
    m_moCellFilter.setCellFilter(m_cellFilterI);
    m_cellFilterSwitch = new SoSwitch();
    m_cellFilterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    {
      m_cellFilterSwitch.addChild(m_moCellFilter);
    }

    // Point probe section
    MoMeshPointProbe pointProbe = new MoMeshPointProbe();

    SoTranslation trans1 = new SoTranslation();
    trans1.translation.connectFrom(pointProbe.position);

    // Probe display
    SoTranslation trans2 = new SoTranslation();
    trans2.translation.setValue(0.5f, 0.f, 0.f);
    SoText2 cellIndexText = new SoText2();
    cellIndexText.justification.setValue(SoText2.Justifications.LEFT);

    SoTranslation trans3 = new SoTranslation();
    trans3.translation.setValue(0.f, -0.15f, 0.f);
    SoText2 cellValueText = new SoText2();
    cellValueText.justification.setValue(SoText2.Justifications.LEFT);

    SoPickStyle ps = new SoPickStyle();
    ps.style.setValue(SoPickStyle.Styles.UNPICKABLE);

    m_cameraOrientation = new SoRotation();
    SoSwitch textSwitch = new SoSwitch();
    textSwitch.whichChild.setValue(SoSwitch.WhichChild.SO_SWITCH_NONE.getValue());
    {
      textSwitch.addChild(ps);
      textSwitch.addChild(m_cameraOrientation);
      textSwitch.addChild(trans2);
      textSwitch.addChild(cellIndexText);
      textSwitch.addChild(trans3);
      textSwitch.addChild(cellValueText);
    }

    SoAnnotation annotation = new SoAnnotation();
    annotation.fastEditing.setValue(SoSeparator.FastEditings.KEEP_ZBUFFER);
    {
      annotation.addChild(trans1);
      annotation.addChild(textSwitch);
    }

    ProbeCallback probeCB = new ProbeCallback(textSwitch, cellIndexText, cellValueText);
    pointProbe.setProbeCallback(probeCB);

    SoEventCallback myCallbackNode3 = new SoEventCallback();
    myCallbackNode3.addEventCallback(SoLocation2Event.class, new MouseMoveCB(pointProbe));

    // Mesh skin
    MoDrawStyle style = new MoDrawStyle();
    style.displayEdges.setValue(true);
    MoMaterial material = new MoMaterial();
    material.lineColoring.setValue(MoMaterial.ColoringType.COLOR);
    material.lineColor.setValue(1.f, 1.f, 1.f);
    SoLightModel lModel = new SoLightModel();
    lModel.model.setValue(SoLightModel.Models.BASE_COLOR);

    MoMeshSkin skin = new MoMeshSkin();
    m_skinSwitch = new SoSwitch();
    m_skinSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    m_skinSwitch.addChild(skin);

    SoSeparator root = new SoSeparator();
    { // assemble scene graph
      root.addChild(sh);
      root.addChild(m_moMesh);
      root.addChild(m_colMap);
      root.addChild(m_moScalarSetI);
      root.addChild(m_moScalarSetIjk);
      root.addChild(moVec3Set);
      root.addChild(m_moVec3SetIjk);
      root.addChild(dataBinding);
      root.addChild(m_cellFilterSwitch);
      root.addChild(pointProbe);
      root.addChild(annotation);
      root.addChild(myCallbackNode3);

      root.addChild(style);
      root.addChild(material);
      root.addChild(lModel);
      root.addChild(m_skinSwitch);
    }

    return root;
  }

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain("PointProbe Example");
  }

}
