package meshvizxlm.mesh.data;

import com.openinventor.meshvizxlm.MxTimeStamp;
import com.openinventor.meshvizxlm.mesh.data.DataBinding;
import com.openinventor.meshvizxlm.mesh.data.MiDataSet;

public class MbDataSet implements MiDataSet, Comparable<MbDataSet>
{

  protected DataBinding m_binding;
  protected String m_name;
  protected long m_timeStamp;

  public MbDataSet()
  {
    this.m_binding = DataBinding.PER_NODE;
    this.m_timeStamp = MxTimeStamp.getTimeStamp();
    this.m_name = "";
  }

  public MbDataSet(String name, DataBinding binding)
  {
    this.m_name = name;
    this.m_binding = binding;
    this.m_timeStamp = MxTimeStamp.getTimeStamp();
  }

  public void touch()
  {
    this.m_timeStamp = MxTimeStamp.getTimeStamp();
  }

  @Override
  public DataBinding getBinding()
  {
    return this.m_binding;
  }

  @Override
  public String getName()
  {
    return this.m_name;
  }

  public void setName(String name)
  {
    this.m_name = name;
  }

  @Override
  public long getTimeStamp()
  {
    return this.m_timeStamp;
  }

  @Override
  public int compareTo(MbDataSet o)
  {
    return m_name.compareTo(o.getName());
  }

}
